/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.log.Logger;

public abstract class JmxMonitoring {
    private static final Logger log = Logger.getLogger(JmxMonitoring.class.getName());
    private Map<ObjectName, List<MBeanAttributeInfo>> beans = new HashMap<ObjectName, List<MBeanAttributeInfo>>();

    protected abstract String getQuery();

    protected abstract String getMBeanName(String var1);

    public boolean checks(MBeanServer mbs) {
        String queryString = this.getQuery();
        if (queryString.contains("*") && System.getProperty("java.version").startsWith("1.5")) {
            return false;
        }
        try {
            ObjectName query = new ObjectName(queryString);
            return !mbs.queryNames(query, null).isEmpty();
        }
        catch (MalformedObjectNameException e) {
            log.severe(e, e.getMessage(), new Object[0]);
            return false;
        }
    }

    public List<RawDataProtocol.MBean.Builder> getConfig(MBeanServer mbs) throws Exception {
        return this.get(mbs, false);
    }

    public List<RawDataProtocol.MBean.Builder> getData(MBeanServer mbs) throws Exception {
        return this.get(mbs, true);
    }

    protected boolean filter(String objectName) {
        return false;
    }

    private List<RawDataProtocol.MBean.Builder> get(MBeanServer mbs, boolean withValue) throws Exception {
        ArrayList<RawDataProtocol.MBean.Builder> tmp = new ArrayList<RawDataProtocol.MBean.Builder>();
        ObjectName query = new ObjectName(this.getQuery());
        for (ObjectName object : mbs.queryNames(query, null)) {
            ObjectName objectName;
            try {
                objectName = object;
            }
            catch (ClassCastException e) {
                log.fine(e, "failed to cast objectname", new Object[0]);
                continue;
            }
            if (this.filter(objectName.toString())) continue;
            RawDataProtocol.MBean.Builder mbean = RawDataProtocol.MBean.newBuilder();
            mbean.setObjectName(this.getMBeanName(objectName.toString()));
            mbean.setCollectingTime(System.currentTimeMillis());
            for (MBeanAttributeInfo attribute : mbs.getMBeanInfo(objectName).getAttributes()) {
                if (!this.isTypeSupported(attribute.getType())) continue;
                RawDataProtocol.MBeanAttributeInfo.Builder builder = RawDataProtocol.MBeanAttributeInfo.newBuilder();
                builder.setName(attribute.getName());
                builder.setDescription("");
                builder.setType(attribute.getType());
                String value = "#NOT_READABLE#";
                if (withValue && attribute.isReadable()) {
                    try {
                        value = mbs.getAttribute(objectName, attribute.getName()).toString();
                    }
                    catch (Exception e) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("error :");
                        buf.append(e.getMessage());
                        buf.append(" - objectName:");
                        buf.append(objectName.toString());
                        buf.append(" - attribute: ");
                        buf.append(attribute.getName());
                        log.warning(buf.toString(), new Object[0]);
                    }
                }
                builder.setValue(value);
                mbean.addAttributeInfo(builder);
            }
            if (mbean.getAttributeInfoBuilderList() == null || mbean.getAttributeInfoBuilderList().size() <= 0) continue;
            tmp.add(mbean);
        }
        return tmp;
    }

    private boolean isTypeSupported(String type) {
        return type != null && (type.equals("int") || type.equals(Integer.class.getName()) || type.equals("long") || type.equals(Long.class.getName()) || type.equals("double") || type.equals(Double.class.getName()) || type.equals("float") || type.equals(Float.class.getName()));
    }
}

