/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.jvm.JvmInfo;

public class ServerConfigBuilder {
    private static InetAddress localhost;

    public RawDataProtocol.ServerConfig.Builder getBuffer(JvmInfo jvmInfo, Long serverPort, String serverInfo, String version, boolean extended) {
        RawDataProtocol.ServerConfig.Builder builder = RawDataProtocol.ServerConfig.newBuilder();
        if (extended) {
            builder.setOsArch(jvmInfo.getSystemProperties().getProperty("os.arch"));
            builder.setOsName(jvmInfo.getSystemProperties().getProperty("os.name"));
            builder.setOsVersion(jvmInfo.getSystemProperties().getProperty("os.version"));
            builder.setVmVersion(jvmInfo.getSystemProperties().getProperty("java.version"));
            builder.setVmVendor(jvmInfo.getSystemProperties().getProperty("java.vendor"));
        }
        builder.setAvailableProcessors(Runtime.getRuntime().availableProcessors());
        RuntimeMXBean rtMXBean = ManagementFactory.getRuntimeMXBean();
        builder.setStartTime(rtMXBean.getStartTime());
        if (extended) {
            builder.setVmName(rtMXBean.getName());
            if (rtMXBean.isBootClassPathSupported()) {
                builder.setBootClassPath(rtMXBean.getBootClassPath());
            }
        }
        builder.setJvmInfo(jvmInfo.toRawDataProtocol(extended));
        if (serverPort != null) {
            builder.setServerPort(serverPort.intValue());
        }
        boolean first = true;
        StringBuilder buf = new StringBuilder(500);
        for (String argument : rtMXBean.getInputArguments()) {
            if (!extended && !argument.startsWith("-X")) continue;
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(argument);
        }
        builder.setInputArguments(buf.toString());
        builder.setNudgeVersion(version);
        String hostNamePort = jvmInfo.getHostName();
        if (null != serverPort) {
            hostNamePort = hostNamePort + ":" + serverPort;
        }
        builder.setHostName(hostNamePort);
        if (serverInfo != null) {
            builder.setServerInfo(serverInfo);
        } else {
            builder.setServerInfo("");
        }
        if (null == localhost) {
            try {
                localhost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null != localhost) {
            builder.setCanonicalHostName(localhost.getCanonicalHostName());
            if (serverPort != null) {
                builder.setHostAddress(localhost.getHostAddress() + ":" + serverPort.toString());
                builder.setHostName(localhost.getHostName() + ":" + serverPort.toString());
            } else {
                builder.setHostAddress(localhost.getHostAddress());
                builder.setHostName(localhost.getHostName());
            }
        }
        return builder;
    }
}

