/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.log.Logger;

public class ThreadActivityBuilder {
    private static final Logger LOG = Logger.getLogger(ThreadActivityBuilder.class.getName());
    private long start = 0L;
    private long end = 0L;
    private long count = 0L;
    private long oldCpuTime = 0L;
    private long oldUserTime = 0L;

    public RawDataProtocol.ThreadActivity getBuffer() {
        this.start = this.start == 0L ? System.currentTimeMillis() : this.end;
        RawDataProtocol.ThreadActivity.Builder builder = RawDataProtocol.ThreadActivity.newBuilder();
        builder.setStartTime(this.start);
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        builder.setCount(threads.getThreadCount());
        builder.setDaemonThreadCount(threads.getDaemonThreadCount());
        long total = threads.getTotalStartedThreadCount();
        builder.setNewThreadCount((int)(total - this.count));
        this.count = total;
        long newCpuTime = 0L;
        long newUserTime = 0L;
        for (ThreadInfo info : threads.getThreadInfo(threads.getAllThreadIds())) {
            long id = info.getThreadId();
            newCpuTime += threads.getThreadCpuTime(id) / 1000000L;
            newUserTime += threads.getThreadUserTime(id) / 1000000L;
        }
        if (this.oldCpuTime < newCpuTime) {
            builder.setCpuTime(newCpuTime - this.oldCpuTime);
        } else {
            builder.setCpuTime(newCpuTime + 9223372036854L - this.oldCpuTime);
        }
        this.oldCpuTime = newCpuTime;
        if (this.oldUserTime < newUserTime) {
            builder.setUserTime(newUserTime - this.oldUserTime);
        } else {
            builder.setUserTime(newUserTime + 9223372036854L - this.oldUserTime);
        }
        this.oldUserTime = newUserTime;
        this.end = System.currentTimeMillis();
        builder.setEndTime(this.end);
        return builder.build();
    }
}

