/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.nudge.dependency.cgg.Gson;
import org.nudge.dependency.cgp.GeneratedMessageV3;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Configuration;
import org.nudge.probe.collector.CollectorImpl;
import org.nudge.probe.collector.NudgeConnector;
import org.nudge.probe.json.Backtrace;
import org.nudge.probe.json.SqlRequest;
import org.nudge.probe.json.Transaction;
import org.nudge.probe.json.WSRequest;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.log.Logger;

public class Listener {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final int portNumber = 5555;
    private static Gson gson = new Gson();
    private static final String stopMessage = "FINITO!";
    private static final String stopResponse = "!OK_ENDED";
    private static boolean end = false;

    public static void start(Configuration config, NudgeConnector connector) throws Exception {
        try {
            final CollectorImpl collector = new CollectorImpl(config, new JvmInfo(config), connector);
            final ServerSocket sock = new ServerSocket(5555, 100, InetAddress.getByName(null));
            while (!end) {
                final Socket clientSocket = sock.accept();
                clientSocket.setSoTimeout(10000);
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                            try {
                                String inputLine;
                                while ((inputLine = in.readLine()) != null) {
                                    GeneratedMessageV3.Builder s;
                                    long elapse;
                                    long min;
                                    if (Listener.stopMessage.equals(inputLine)) {
                                        out.println(Listener.stopResponse);
                                        out.flush();
                                        end = true;
                                        sock.close();
                                        break;
                                    }
                                    Transaction tr = this.parseTransactionFromJson(inputLine);
                                    if (tr == null) {
                                        return;
                                    }
                                    log.fine(tr.toString(), new Object[0]);
                                    RawDataProtocol.Transaction.Builder builder = RawDataProtocol.Transaction.newBuilder();
                                    builder.setUrl(tr.getUrl());
                                    builder.setStartTime(tr.getStart());
                                    builder.setEndTime(tr.getEnd());
                                    builder.setUuid(tr.getUuid());
                                    builder.setUserAgent(tr.getUseragent());
                                    builder.setUserIp(tr.getIp());
                                    builder.setRespStatusCode(tr.getResponsecode());
                                    if (tr.getResponsecode() < 400) {
                                        builder.setStatus(RawDataProtocol.Transaction.Status.OK);
                                    } else {
                                        builder.setStatus(RawDataProtocol.Transaction.Status.KO);
                                    }
                                    if (tr.getEum() != null && !"".equals(tr.getEum())) {
                                        collector.sendEndUserTiming(tr.getEum());
                                    }
                                    for (Map.Entry<String, Object> e : tr.getParams().entrySet()) {
                                        RawDataProtocol.Param.Builder p = RawDataProtocol.Param.newBuilder();
                                        p.setKey(e.getKey());
                                        p.setValue(e.toString());
                                        builder.addParams(p);
                                    }
                                    if (tr.getSqlRequests() != null) {
                                        long cum = 0L;
                                        long max = 0L;
                                        min = 0L;
                                        for (SqlRequest sql : tr.getSqlRequests()) {
                                            elapse = sql.getEnd() - sql.getStart();
                                            cum += elapse;
                                            max = Math.max(max, elapse);
                                            min = Math.min(min, elapse);
                                            s = RawDataProtocol.SqlRequest.newBuilder();
                                            ((RawDataProtocol.SqlRequest.Builder)s).setCount(1);
                                            ((RawDataProtocol.SqlRequest.Builder)s).setStartTime(sql.getStart());
                                            ((RawDataProtocol.SqlRequest.Builder)s).setEndTime(sql.getEnd());
                                            ((RawDataProtocol.SqlRequest.Builder)s).setRequestType(RawDataProtocol.SqlRequest.RequestType.JDBC);
                                            ((RawDataProtocol.SqlRequest.Builder)s).setServerUrl("Database");
                                            ((RawDataProtocol.SqlRequest.Builder)s).setSql(sql.getCode());
                                            builder.addSqlRequests((RawDataProtocol.SqlRequest.Builder)s);
                                        }
                                        if (tr.getSqlRequests().size() > 0) {
                                            builder.setDbQueryAvg(cum / (long)tr.getSqlRequests().size());
                                        } else {
                                            builder.setDbQueryAvg(0L);
                                        }
                                        builder.setDbQueryCount(tr.getSqlRequests().size());
                                        builder.setDbQueryMax(max);
                                        builder.setDbQueryMin(min);
                                    }
                                    if (tr.getWsRequests() != null) {
                                        long cum = 0L;
                                        long max = 0L;
                                        min = 0L;
                                        for (WSRequest ws : tr.getWsRequests()) {
                                            elapse = ws.getEnd() - ws.getStart();
                                            cum += elapse;
                                            max = Math.max(max, elapse);
                                            min = Math.min(min, elapse);
                                            s = RawDataProtocol.WSRequest.newBuilder();
                                            ((RawDataProtocol.WSRequest.Builder)s).setStartTime(ws.getStart());
                                            ((RawDataProtocol.WSRequest.Builder)s).setEndTime(ws.getEnd());
                                            ((RawDataProtocol.WSRequest.Builder)s).setUrl(ws.getUrl());
                                            ((RawDataProtocol.WSRequest.Builder)s).setWsType(RawDataProtocol.WSRequest.WSType.REST);
                                            builder.addWsRequests((RawDataProtocol.WSRequest.Builder)s);
                                        }
                                        if (tr.getWsRequests().size() > 0) {
                                            builder.setWsAvg(cum / (long)tr.getWsRequests().size());
                                        } else {
                                            builder.setWsAvg(0L);
                                        }
                                        builder.setWsCount(tr.getWsRequests().size());
                                        builder.setWsMax(max);
                                        builder.setWsMin(min);
                                    }
                                    try {
                                        if (tr.getBacktraces() != null) {
                                            for (Backtrace b : tr.getBacktraces()) {
                                                if (b.getCalls().size() <= 0) continue;
                                                RawDataProtocol.ThreadInfo.Builder tib = RawDataProtocol.ThreadInfo.newBuilder();
                                                tib.setState(RawDataProtocol.ThreadInfo.State.RUNNABLE);
                                                tib.setTimeStamp(b.getTimestamp());
                                                tib.setUuid(builder.getUuid());
                                                tib.setUrl(b.getCalls().get(0).getFile() + "." + b.getCalls().get(0).getFunction());
                                                for (Backtrace.Call c : b.getCalls()) {
                                                    RawDataProtocol.ThreadInfo.StackTraceElement.Builder steb = RawDataProtocol.ThreadInfo.StackTraceElement.newBuilder();
                                                    steb.setClassName(c.getFile());
                                                    steb.setMethodName(c.getFunction());
                                                    steb.setLineNumber(c.getLine());
                                                    tib.addFrames(0, steb);
                                                }
                                                collector.send(tib);
                                            }
                                        }
                                        collector.send(builder);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            catch (SocketTimeoutException ste) {
                                out.println("Timed out");
                                out.flush();
                                System.err.println("Timed out socket");
                            }
                            finally {
                                in.close();
                                out.close();
                                clientSocket.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }

                    private Transaction parseTransactionFromJson(String inputLine) {
                        try {
                            return gson.fromJson(inputLine, Transaction.class);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to parse " + inputLine + "\nError : " + e.getMessage());
                            return null;
                        }
                    }
                });
                t.setDaemon(true);
                t.start();
            }
            sock.close();
        }
        catch (SocketException collector) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void stop() {
        try {
            Socket sock = new Socket(InetAddress.getByName(null), 5555);
            BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            PrintWriter out = new PrintWriter(sock.getOutputStream());
            out.println(stopMessage);
            out.flush();
            if (stopResponse.equals(in.readLine())) {
                log.severe("Service ended successfully", new Object[0]);
            } else {
                System.err.println("Failed to stop service");
            }
            out.close();
            in.close();
            sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

