/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.jvm;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.Configuration;
import org.nudge.probe.util.Checker;

public class JvmInfo {
    private static final String UNKNOWN = "Unknown";
    private final JvmInfoProvider provider;
    private final Configuration config;
    private final Map<String, String> explicitComponents = new HashMap<String, String>();
    private String hostName;
    private Map<String, String> detectedComponents = Collections.emptyMap();
    private static final JvmInfoProvider DEFAULT_PROVIDER = new JvmInfoProvider(){

        @Override
        public String getHostName() {
            String result = null;
            try {
                Process exec = Runtime.getRuntime().exec("hostname");
                result = IOUtils.toString(exec.getInputStream()).trim();
            }
            catch (IOException exec) {
                // empty catch block
            }
            if (null == result) {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    result = addr.getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public Properties getSystemProperties() {
            return System.getProperties();
        }

        @Override
        public Map<String, String> detectComponents() {
            HashMap<String, String> components = new HashMap<String, String>();
            for (ApplicationServerDetector detector : appServerDetectors) {
                String version = detector.getVersion();
                if (null == version) continue;
                components.put(detector.getId(), version);
                break;
            }
            return components;
        }
    };
    private static final ApplicationServerDetector[] appServerDetectors = new ApplicationServerDetector[]{new ApplicationServerDetector("tomcat"){

        @Override
        public String getVersion() {
            String jmxAttribute = JvmInfo.getJmxAttribute("Catalina:type=Server", "serverInfo");
            if (null != jmxAttribute) {
                return jmxAttribute;
            }
            String catalinaHome = System.getProperty("catalina.home");
            if (null == catalinaHome) {
                return null;
            }
            File catalinaJar = new File(catalinaHome + "/server/lib/catalina.jar");
            if (!catalinaJar.isFile()) {
                return null;
            }
            return JvmInfo.readPropertiesInJar(new File(catalinaHome + "/server/lib/catalina.jar"), "org/apache/catalina/util/ServerInfo.properties", "server.info", false);
        }
    }, new ApplicationServerDetector("jboss"){

        @Override
        public String getVersion() {
            String name = JvmInfo.getJmxAttribute("jboss.as:management-root=server", "productName");
            String version = JvmInfo.getJmxAttribute("jboss.as:management-root=server", "productVersion");
            if (null != name && null != version) {
                return name + " " + version;
            }
            version = JvmInfo.getJmxAttribute("jboss.system:type=Server", "Version");
            if (null != version) {
                return "JBoss AS " + version;
            }
            return null;
        }
    }, new ApplicationServerDetector("jetty"){

        @Override
        public String getVersion() {
            String jmxAttribute = JvmInfo.getJmxAttribute("org.eclipse.jetty.server:type=server,id=0", "version");
            if (null != jmxAttribute) {
                return jmxAttribute;
            }
            jmxAttribute = JvmInfo.getJmxAttribute("org.eclipse.jetty.maven.plugin:type=jettyserver,id=0", "version");
            if (null != jmxAttribute) {
                return jmxAttribute;
            }
            jmxAttribute = JvmInfo.getJmxAttribute("org.mortbay.jetty:type=server,id=0", "version");
            if (null != jmxAttribute) {
                return jmxAttribute;
            }
            String jettyHome = System.getProperty("jetty.home");
            if (null == jettyHome) {
                return null;
            }
            return JvmInfo.readPropertiesInJar(new File(jettyHome + "/start.jar"), "META-INF/MANIFEST.MF", "implementation-version", true);
        }
    }};

    public JvmInfo(JvmInfoProvider provider, Configuration config) {
        Checker.checkArgument(null != provider);
        this.provider = provider;
        Checker.checkArgument(null != config);
        this.config = config;
        this.refresh();
    }

    public JvmInfo(Configuration config) {
        this(DEFAULT_PROVIDER, config);
    }

    public String getHostName() {
        return null != this.hostName ? this.hostName : UNKNOWN;
    }

    public Properties getSystemProperties() {
        return this.provider.getSystemProperties();
    }

    public Map<String, String> getComponents() {
        HashMap<String, String> result = new HashMap<String, String>(this.detectedComponents);
        result.putAll(this.explicitComponents);
        return result;
    }

    public void enableComponent(String name, String value) {
        this.explicitComponents.put(name, value);
    }

    public JvmInfo refresh() {
        this.detectedComponents = this.provider.detectComponents();
        String serviceHostname = this.config.getServiceHostname();
        this.hostName = null != serviceHostname && serviceHostname.length() > 0 ? serviceHostname : this.provider.getHostName();
        return this;
    }

    public RawDataProtocol.JvmInfo toRawDataProtocol(boolean extended) {
        RawDataProtocol.JvmInfo.Builder builder = RawDataProtocol.JvmInfo.newBuilder();
        for (Map.Entry<Object, Object> entry : this.getSystemProperties().entrySet()) {
            if (!extended && !this.notExtendedAllowed(entry.getKey().toString())) continue;
            builder.addSystemPropertiesBuilder().setKey(entry.getKey().toString()).setValue(entry.getValue().toString()).build();
        }
        builder.setHostName(this.getHostName());
        for (Map.Entry<Object, Object> entry : this.getComponents().entrySet()) {
            builder.addComponentsBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue());
        }
        String serviceQualifier = this.config.getServiceQualifier();
        if (null != serviceQualifier) {
            builder.setQualifier(serviceQualifier);
        }
        return builder.build();
    }

    private boolean notExtendedAllowed(String key) {
        return key.startsWith("java.vm.") || key.startsWith("java.version") || key.startsWith("os.");
    }

    private static String getJmxAttribute(String objectName, String attribute) {
        ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer mbeanServer : list) {
            try {
                Object value = mbeanServer.getAttribute(ObjectName.getInstance(objectName), attribute);
                if (null == value) continue;
                return value.toString();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String readPropertiesInJar(File jarFile, String propertiesFile, String property, boolean ignoreCase) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static abstract class ApplicationServerDetector {
        private final String id;

        protected ApplicationServerDetector(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public abstract String getVersion();
    }

    public static class JvmInfoProvider {
        public Properties getSystemProperties() {
            return new Properties();
        }

        public Map<String, String> detectComponents() {
            return Collections.emptyMap();
        }

        public String getHostName() {
            return null;
        }
    }
}

