/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.libscan;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.util.Checker;

public class JarInfo {
    private static Set<Attributes.Name> MANIFEST_WHITELIST = new HashSet<Attributes.Name>(Arrays.asList(Attributes.Name.IMPLEMENTATION_TITLE, Attributes.Name.IMPLEMENTATION_VERSION, Attributes.Name.SPECIFICATION_TITLE, Attributes.Name.SPECIFICATION_VERSION, new Attributes.Name("Bundle-Name"), new Attributes.Name("Bundle-Version")));
    private final String fileName;
    private final String sha1;
    private final Map<String, String> manifest;
    private final List<MavenGAV> maven;

    private JarInfo(String fileName, String sha1, List<MavenGAV> maven, Map<String, String> manifest) {
        Checker.checkArgument(null != fileName);
        this.fileName = fileName;
        Checker.checkArgument(null != sha1);
        this.sha1 = sha1;
        Checker.checkArgument(null != maven);
        this.maven = maven;
        Checker.checkArgument(null != manifest);
        this.manifest = manifest;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSha1() {
        return this.sha1;
    }

    public static JarInfo fromJar(String path) {
        try {
            JarFile jar = new JarFile(path);
            List<MavenGAV> maven = JarInfo.getMavenFromProperties(jar);
            Manifest manifest = jar.getManifest();
            HashMap<String, String> manifestValues = new HashMap<String, String>();
            if (null != manifest) {
                Attributes attributes = manifest.getMainAttributes();
                for (Attributes.Name name : MANIFEST_WHITELIST) {
                    String value = attributes.getValue(name);
                    if (null == value) continue;
                    manifestValues.put(name.toString(), value);
                }
            }
            File file = new File(jar.getName());
            return new JarInfo(file.getName(), JarInfo.fileSha1(path), maven, manifestValues);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to read file " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private static String fileSha1(String path) {
        BufferedInputStream is = null;
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            is = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[1024];
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : digest.digest()) {
                sb.append(String.format("%02x", b));
            }
            Object object = sb.toString();
            IOUtils.closeQuietly(is);
            return object;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (NoSuchAlgorithmException e2) {
            String string = null;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public List<MavenGAV> getMaven() {
        return this.maven;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public String toString() {
        return "JarInfo{fileName='" + this.fileName + '\'' + ", sha1='" + this.sha1 + '\'' + ", manifest=" + this.manifest + ", maven=" + this.maven + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarInfo jarInfo = (JarInfo)o;
        if (this.fileName != null ? !this.fileName.equals(jarInfo.fileName) : jarInfo.fileName != null) {
            return false;
        }
        if (this.sha1 != null ? !this.sha1.equals(jarInfo.sha1) : jarInfo.sha1 != null) {
            return false;
        }
        if (this.manifest != null ? !this.manifest.equals(jarInfo.manifest) : jarInfo.manifest != null) {
            return false;
        }
        return this.maven != null ? this.maven.equals(jarInfo.maven) : jarInfo.maven == null;
    }

    public int hashCode() {
        int result = this.fileName != null ? this.fileName.hashCode() : 0;
        result = 31 * result + (this.sha1 != null ? this.sha1.hashCode() : 0);
        result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
        result = 31 * result + (this.maven != null ? this.maven.hashCode() : 0);
        return result;
    }

    private static List<MavenGAV> getMavenFromProperties(JarFile jar) {
        ArrayList<MavenGAV> maven = new ArrayList<MavenGAV>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/maven") || !name.endsWith("pom.properties")) continue;
            Properties p = new Properties();
            try {
                p.load(jar.getInputStream(entry));
                maven.add(new MavenGAV(p.getProperty("groupId"), p.getProperty("artifactId"), p.getProperty("version")));
            }
            catch (IOException iOException) {}
        }
        return maven;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            System.out.println(JarInfo.fromJar(arg));
        }
    }

    public static class MavenGAV {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public MavenGAV(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "MavenGAV{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenGAV mavenGAV = (MavenGAV)o;
            if (this.groupId != null ? !this.groupId.equals(mavenGAV.groupId) : mavenGAV.groupId != null) {
                return false;
            }
            if (this.artifactId != null ? !this.artifactId.equals(mavenGAV.artifactId) : mavenGAV.artifactId != null) {
                return false;
            }
            return this.version != null ? this.version.equals(mavenGAV.version) : mavenGAV.version == null;
        }

        public int hashCode() {
            int result = this.groupId != null ? this.groupId.hashCode() : 0;
            result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}

