/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.libscan;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.collector.Collector;

public class LibScanTransformer
implements ClassFileTransformer {
    private final Collector collector;
    private static Set<String> jars = new HashSet<String>();

    public LibScanTransformer(Collector collector) {
        this.collector = collector;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String[] parts;
        if (null == protectionDomain) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (null == codeSource) {
            return null;
        }
        URL location = codeSource.getLocation();
        if (null == location) {
            return null;
        }
        String protocol = location.getProtocol();
        String path = location.getPath();
        String componentFile = null;
        if (protocol.equals("file") && !path.endsWith(".class")) {
            componentFile = path;
        } else if (protocol.equals("jar") && (parts = path.split("!")).length == 2 && parts[0].startsWith("file:")) {
            componentFile = parts[0].substring(5);
        }
        if (null != componentFile && !jars.contains(componentFile)) {
            jars.add(componentFile);
            this.collector.addJarComponent(componentFile);
        }
        return null;
    }
}

