/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.log;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import org.nudge.dependency.oaci.FileUtils;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.LoggerMBean;

public class Logger
implements LoggerMBean {
    private static final Logger instance = new Logger(Configuration.DEFAULT_LOG_LEVEL, null);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm'Z'";
    private Handler handler;
    private Level levelValue;

    public static synchronized void setupAndRotate(Configuration config) {
        Logger.instance.levelValue = config.getLogLevel();
        if (!config.hasExplicitLogLevel() && config.useFineLogOnStartup()) {
            Logger.instance.levelValue = Level.FINE;
        }
        Logger.logRotation(config);
        try {
            File logFolder = new File(config.getLogDirectory());
            File logFile = new File(logFolder, Configuration.NUDGE_LOG);
            logFile.createNewFile();
            Logger.instance.handler = new FileHandler(logFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void setLevel(Level newLevel) {
        this.levelValue = newLevel;
    }

    public static synchronized void shutdown() {
        IOUtils.closeQuietly((Closeable)Logger.instance.handler);
    }

    public static Logger getLogger(String name) {
        return instance;
    }

    private Logger(Level levelValue, Handler handler) {
        this.levelValue = levelValue;
        this.handler = handler;
    }

    public boolean isLoggable(Level level) {
        return null != this.handler && null != this.levelValue && level.intValue() >= this.levelValue.intValue() && this.levelValue != Level.OFF;
    }

    public void config(String message, Object ... args) {
        this.log(Level.SEVERE, null, message, args);
    }

    public void severe(String message, Object ... args) {
        this.log(Level.SEVERE, null, message, args);
    }

    public void severe(Throwable t, String message, Object ... args) {
        this.log(Level.SEVERE, t, message, args);
    }

    public void warning(String message, Object ... args) {
        this.log(Level.WARNING, null, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, null, message, args);
    }

    public void info(Throwable t, String message) {
        this.log(Level.INFO, t, message, new Object[0]);
    }

    public void fine(String message, Object ... args) {
        this.log(Level.FINE, null, message, args);
    }

    public void fine(Throwable t, String message, Object ... args) {
        this.log(Level.FINE, t, message, args);
    }

    public void finer(String message) {
        this.log(Level.FINER, null, message, new Object[0]);
    }

    public void finest(String message, Object ... args) {
        this.log(Level.FINEST, null, message, args);
    }

    public void finest(Throwable t, String message, Object ... args) {
        this.log(Level.FINEST, t, message, args);
    }

    private void log(Level level, Throwable t, String message, Object ... args) {
        if (this.isLoggable(level)) {
            this.doLog(level, String.format(message, args), t);
        }
    }

    private void doLog(Level level, String message, Throwable t) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        formatter.setTimeZone(tz);
        this.handler.write(String.format("%s %s %s | %s\n", new Object[]{formatter.format(new Date()), level, Thread.currentThread().getName(), message == null ? "" : message}));
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.handler.write(sw.toString());
        }
    }

    static void logRotation(final Configuration config) {
        File directory = new File(config.getLogDirectory());
        File[] toDelete = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = Configuration.NUDGE_ROTATE_PATTERN.matcher(name);
                if (matcher.matches()) {
                    int i = Integer.parseInt(matcher.group(1));
                    return i >= config.getlogRotationCount();
                }
                return false;
            }
        });
        if (null != toDelete) {
            for (File file : toDelete) {
                FileUtils.deleteQuietly(file);
            }
        }
        for (int i = config.getlogRotationCount() - 1; i >= 0; --i) {
            File source = new File(directory, 0 == i ? Configuration.NUDGE_LOG : String.format(Configuration.NUDGE_ROTATE_FORMAT, i));
            File destination = new File(directory, String.format(Configuration.NUDGE_ROTATE_FORMAT, i + 1));
            if (!source.exists()) continue;
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                try {
                    Files.move(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(String.format("unable to move (windows os detected) %s -> %s", source, destination));
                }
            }
            if (source.renameTo(destination)) continue;
            throw new IllegalStateException(String.format("unable to rename %s -> %s", source, destination));
        }
    }

    @Override
    public String getLevel() {
        return this.levelValue.toString();
    }

    @Override
    public void setLevel(String level) {
        this.levelValue = Level.valueOf(level);
    }

    private static class FileHandler
    implements Handler {
        private Writer writer;
        private final AtomicBoolean closed;

        private FileHandler(File file) throws IOException {
            FileOutputStream fout = new FileOutputStream(file);
            this.writer = new OutputStreamWriter(fout);
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public void write(String message) {
            if (this.closed.get()) {
                return;
            }
            try {
                this.writer.write(message);
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void flush() {
            try {
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
            IOUtils.closeQuietly(this.writer);
        }
    }

    private static interface Handler
    extends Closeable {
        public void write(String var1);

        public void flush();
    }
}

