/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.logparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.UUID;
import org.nudge.dependency.cgg.JsonObject;
import org.nudge.dependency.cgg.JsonParser;
import org.nudge.dependency.cgg.JsonPrimitive;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.Configuration;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.Util;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.collector.CollectorImpl;
import org.nudge.probe.collector.NudgeConnector;
import org.nudge.probe.collector.Orchestrator;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.events.ProtocolFacadeImpl;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.log.Logger;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.spi.NudgeProbeSpi;

public class ApacheLogParser {
    public static void uploadFile(String filename) {
        File f = new File(filename);
        if (!f.isFile() || !f.canRead()) {
            System.err.println("can't open file for reading : " + f.getAbsolutePath());
            System.exit(2);
        }
        ProbeJar jar = ProbeJar.fromPackaging();
        Configuration config = Configuration.buildFromSystemProperties(System.getProperties(), jar, false);
        Logger.setupAndRotate(config);
        Logger log = Logger.getLogger(null);
        JvmInfo jvmInfo = new JvmInfo(config);
        NudgeProbe probe = NudgeProbeSpi.getProbeSpi(config, jvmInfo);
        CollectorImpl collector = new CollectorImpl(config, jvmInfo, new NudgeConnector(config, probe.newHttpConnector()));
        Orchestrator orchestrator = Orchestrator.batchMode(config, collector);
        orchestrator.start();
        log.info("starting file import", new Object[0]);
        ApacheLogParser.sendFile(f, collector);
        log.info("file processing done", new Object[0]);
        orchestrator.stop();
    }

    private static void sendFile(File f, Collector collector) {
        JsonParser parser = new JsonParser();
        try {
            String line;
            BufferedReader reader = IOUtils.toBufferedReader(new FileReader(f));
            do {
                if (null == (line = reader.readLine())) continue;
                JsonObject json = parser.parse(line).getAsJsonObject();
                long start = ApacheLogParser.parsePrimitive(json, "time_s").getAsLong() * 1000L;
                long duration = ApacheLogParser.parsePrimitive(json, "duration_us").getAsLong() / 1000L;
                long end = start + duration;
                int port = ApacheLogParser.parsePrimitive(json, "port").getAsInt();
                String host = ApacheLogParser.parsePrimitive(json, "host").getAsString();
                String request = ApacheLogParser.parsePrimitive(json, "request").getAsString();
                String method = ApacheLogParser.parsePrimitive(json, "method").getAsString();
                int status = ApacheLogParser.parsePrimitive(json, "status").getAsInt();
                String userAgent = ApacheLogParser.parsePrimitive(json, "method").getAsString();
                RawDataProtocol.Transaction.Builder tx = RawDataProtocol.Transaction.newBuilder();
                ProtocolFacade protocol = ApacheLogParser.newProtocol(tx);
                request = Util.simplifyUrl(request);
                protocol.setCode(request).setType("HTTP").addExtendedCode(ExtendedCode.extCode("http.method", method)).addExtendedCode(ExtendedCode.extCode("http.request.header.User-Agent", userAgent)).addExtendedCode(ExtendedCode.extCode("http.status", Integer.toString(status)));
                collector.send(tx.setStartTime(start).setEndTime(end).setUuid(UUID.randomUUID().toString()));
            } while (line != null);
        }
        catch (FileNotFoundException e) {
            throw new ParsingException(e);
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    private static ProtocolFacade newProtocol(RawDataProtocol.Transaction.Builder tx) {
        return new ProtocolFacadeImpl(tx);
    }

    private static JsonPrimitive parsePrimitive(JsonObject json, String property) {
        ApacheLogParser.checkPropertyIsPresent(json, property);
        return json.getAsJsonPrimitive(property);
    }

    private static void checkPropertyIsPresent(JsonObject json, String property) {
        if (!json.has(property)) {
            throw new ParsingException("invalid file format, missing attribute : " + property);
        }
    }

    private static final class ParsingException
    extends RuntimeException {
        private ParsingException(Throwable cause) {
            super(cause);
        }

        private ParsingException(String msg) {
            super(msg);
        }
    }
}

