/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.sampler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.log.Logger;
import org.nudge.probe.sampler.LimitSampler;
import org.nudge.probe.util.Checker;

public class JmxBeansSampler
extends LimitSampler {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final ObjectName GLASSFISH_AMX;
    private static final ObjectName GLASSFISH_BOOT_AMX;
    private static final String GLASSFISH_BOOT_AMX_METHOD = "bootAMX";
    private static final String GLASSFISH_AMX_PREFIX = "amx:";
    private static final Map<MBeanServer, Object> altMBS;
    private final Collector collector;
    private final Configuration config;
    private MBeanServer plateformMbs;
    private List<MBeanInstance> knownInstances = null;
    private long samplingCounter = 0L;
    boolean firstTimeQuerying = true;
    private boolean amxInitiated = false;

    public static void addAlternativeMBeanServer(MBeanServer mbs) {
        altMBS.put(mbs, "");
    }

    public JmxBeansSampler(Collector collector, Configuration config, CurrentTime time) {
        super("jmxbeans", time, config.isActivateJmx());
        Checker.checkArgument(null != collector);
        this.collector = collector;
        this.config = config;
    }

    public void setMBeanServer(MBeanServer mbs) {
        Checker.checkArgument(null != mbs);
        this.plateformMbs = mbs;
    }

    @Override
    public int getSampleInterval() {
        return this.config.getJmxSampleInterval();
    }

    @Override
    protected int getMaxSampleTime() {
        return this.config.getJmxSampleMaxTime();
    }

    @Override
    protected void sample() {
        if (null == this.plateformMbs || !this.config.isActivateJmx() || this.config.getMbeansMonitored().isEmpty()) {
            return;
        }
        List<MBeanInstance> instances = this.getMBeanInstancesToSample();
        int nbOfAttributes = 0;
        for (MBeanInstance instance : instances) {
            if (nbOfAttributes >= this.config.getMaxMbeanAttributesMonitored()) break;
            RawDataProtocol.MBean.Builder mbBuilder = RawDataProtocol.MBean.newBuilder();
            ObjectName objectName = instance.key.object.getObjectName();
            mbBuilder.setObjectName(objectName.toString());
            mbBuilder.setCollectingTime(this.time.currentTimeMillis());
            for (MBeanAttributeInfo attr : instance.mbeanAttribute) {
                if ((nbOfAttributes += this.readAttributes(instance.key.mbs, objectName, attr, mbBuilder)) < this.config.getMaxMbeanAttributesMonitored()) continue;
                log.warning("Max number (%d) of MBean attributes reached", this.config.getMaxMbeanAttributesMonitored());
                break;
            }
            this.collector.send(mbBuilder);
        }
    }

    private List<MBeanInstance> getMBeanInstancesToSample() {
        ++this.samplingCounter;
        if (this.knownInstances == null || this.samplingCounter < 10L || this.samplingCounter % 60L == 0L) {
            boolean existsAmx = false;
            HashMap<ObjectKey, List<String>> objectInstances = new HashMap<ObjectKey, List<String>>();
            for (String s : this.config.getMbeansMonitored()) {
                existsAmx = existsAmx || s.startsWith(GLASSFISH_AMX_PREFIX);
                MBeanConfig mbeanConfig = this.parseMBeanConfigElement(s.trim().replaceAll(" +", " "));
                for (ObjectInstance instance : mbeanConfig.objects) {
                    objectInstances.put(ObjectKey.of(mbeanConfig.mbs, instance), mbeanConfig.attributes);
                }
            }
            if (existsAmx) {
                this.initGlassfishAmxIfRequired();
            }
            ArrayList<MBeanInstance> instances = new ArrayList<MBeanInstance>();
            for (Map.Entry objectInstance : objectInstances.entrySet()) {
                MBeanInstance mbeanInstance = MBeanInstance.newInstance((ObjectKey)objectInstance.getKey());
                instances.add(mbeanInstance);
                ObjectName objectName = ((ObjectKey)objectInstance.getKey()).object.getObjectName();
                boolean allAttrs = objectInstance.getValue() == null;
                for (MBeanAttributeInfo attributeInfo : this.getAttributes(((ObjectKey)objectInstance.getKey()).mbs, objectName)) {
                    if (!allAttrs && !((List)objectInstance.getValue()).contains(attributeInfo.getName())) continue;
                    mbeanInstance.mbeanAttribute.add(attributeInfo);
                }
            }
            this.knownInstances = instances;
        }
        return this.knownInstances;
    }

    private MBeanConfig parseMBeanConfigElement(String element) {
        MBeanConfig result = new MBeanConfig();
        if (!element.contains(" ")) {
            result.mbs = this.plateformMbs;
            result.objects = this.queryMBeans(this.plateformMbs, element);
            if (null == result || result.objects.isEmpty()) {
                Iterator<MBeanServer> iterator = altMBS.keySet().iterator();
                while (iterator.hasNext()) {
                    MBeanServer altMbs;
                    result.mbs = altMbs = iterator.next();
                    result.objects = this.queryMBeans(altMbs, element);
                    if (null == result || result.objects.isEmpty()) continue;
                    log.fine("Found mbean attributes for pattern [%s]", element);
                    break;
                }
            }
        } else {
            String[] splitted = element.split(" ");
            result.mbs = this.plateformMbs;
            result.objects = this.queryMBeans(this.plateformMbs, splitted[0]);
            if (null == result || result.objects.isEmpty()) {
                Iterator<MBeanServer> iterator = altMBS.keySet().iterator();
                while (iterator.hasNext()) {
                    MBeanServer altMbs;
                    result.mbs = altMbs = iterator.next();
                    result.objects = this.queryMBeans(altMbs, element);
                    if (null == result || result.objects.isEmpty()) continue;
                    log.fine("Found mbean attributes for pattern [%s]", element);
                    break;
                }
            }
            result.attributes = Arrays.asList(splitted[1].split(","));
        }
        return result;
    }

    private int readAttributes(MBeanServer mbs, ObjectName objectName, MBeanAttributeInfo attributeInfo, RawDataProtocol.MBean.Builder mbBuilder) {
        Checker.checkArgument(null != attributeInfo);
        String type = attributeInfo.getType();
        log.finest("reading attributes [%s] [%s] [%s] [%s]", mbs.toString(), objectName.toString(), attributeInfo.getName(), type);
        boolean isComposite = type.equals("javax.management.openmbean.CompositeData");
        String attribute = attributeInfo.getName();
        if (null != attribute && attributeInfo.isReadable()) {
            if (isComposite) {
                return this.readCompositeAttribute(mbBuilder, mbs, objectName, attribute);
            }
            int value = this.readAttribute(mbBuilder, mbs, objectName, attribute);
            return value;
        }
        return 0;
    }

    private Set<ObjectInstance> queryMBeans(MBeanServer mbs, String query) {
        if (this.firstTimeQuerying) {
            this.firstTimeQuerying = false;
            this.logMBeanTree();
        }
        Set<ObjectInstance> result = Collections.emptySet();
        try {
            ObjectName objectPattern = new ObjectName(query);
            result = mbs.queryMBeans(objectPattern, null);
        }
        catch (Exception e) {
            log.fine(e, e.getMessage(), new Object[0]);
        }
        return result;
    }

    private void logMBeanTree() {
        log.fine("List of existing MBean", new Object[0]);
        for (ObjectInstance mbean : this.plateformMbs.queryMBeans(null, null)) {
            log.fine("MBean list : %s", ((Object)mbean).toString());
        }
        for (MBeanServer mb : altMBS.keySet()) {
            for (ObjectInstance mbean : mb.queryMBeans(null, null)) {
                log.fine("Alt MBean (%s) list : %s", mb.toString(), ((Object)mbean).toString());
            }
        }
    }

    private int readAttribute(RawDataProtocol.MBean.Builder mbBuilder, MBeanServer mbs, ObjectName objectName, String name) {
        Object value = JmxBeansSampler.getAttributeValue(mbs, objectName, name);
        return JmxBeansSampler.addValue(mbBuilder, name, value);
    }

    private int readCompositeAttribute(RawDataProtocol.MBean.Builder mbBuilder, MBeanServer mbs, ObjectName objectName, String attribute) {
        int nbOfAttributes = 0;
        Object attr = JmxBeansSampler.getAttributeValue(mbs, objectName, attribute);
        if (!(attr instanceof CompositeData)) {
            log.finest("unknown or unreadable mbean %s -> %s", objectName.getCanonicalName(), attribute);
        } else {
            CompositeData cds = (CompositeData)attr;
            Set<String> keys = cds.getCompositeType().keySet();
            for (String key : keys) {
                nbOfAttributes += JmxBeansSampler.addValue(mbBuilder, String.format("%s.%s", attribute, key), cds.get(key));
            }
        }
        return nbOfAttributes;
    }

    private MBeanAttributeInfo[] getAttributes(MBeanServer mbs, ObjectName objectName) {
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = mbs.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            log.finest(e, e.getMessage(), new Object[0]);
        }
        return null != mBeanInfo ? mBeanInfo.getAttributes() : new MBeanAttributeInfo[]{};
    }

    private static Object getAttributeValue(MBeanServer mbs, ObjectName objectName, String name) {
        try {
            return mbs.getAttribute(objectName, name);
        }
        catch (Exception e) {
            log.fine(e, e.getMessage(), new Object[0]);
            return null;
        }
    }

    private static int addValue(RawDataProtocol.MBean.Builder mbBuilder, String name, Object value) {
        int result = 0;
        if (null != value && value instanceof Number) {
            mbBuilder.addAttributeInfoBuilder().setName(name).setValue(value.toString());
            ++result;
        }
        return result;
    }

    private void initGlassfishAmxIfRequired() {
        if (!this.amxInitiated && this.plateformMbs.queryMBeans(GLASSFISH_AMX, null).isEmpty() && !this.plateformMbs.queryMBeans(GLASSFISH_BOOT_AMX, null).isEmpty()) {
            try {
                this.plateformMbs.invoke(GLASSFISH_BOOT_AMX, GLASSFISH_BOOT_AMX_METHOD, null, null);
                this.amxInitiated = true;
            }
            catch (Exception e) {
                log.finest("unable to boot Glassfish AMX", e);
            }
        }
    }

    static {
        altMBS = new ConcurrentHashMap<MBeanServer, Object>();
        try {
            GLASSFISH_AMX = new ObjectName("amx:type=amx");
            GLASSFISH_BOOT_AMX = new ObjectName("amx-support:type=boot-amx");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ObjectKey {
        MBeanServer mbs;
        ObjectInstance object;

        private ObjectKey() {
        }

        private static ObjectKey of(MBeanServer mbs, ObjectInstance object) {
            ObjectKey result = new ObjectKey();
            result.mbs = mbs;
            result.object = object;
            return result;
        }
    }

    private class MBeanConfig {
        MBeanServer mbs;
        Set<ObjectInstance> objects;
        List<String> attributes;

        private MBeanConfig() {
        }
    }

    private static class MBeanInstance {
        ObjectKey key;
        List<MBeanAttributeInfo> mbeanAttribute;

        private MBeanInstance() {
        }

        static MBeanInstance newInstance(ObjectKey key) {
            MBeanInstance result = new MBeanInstance();
            result.mbeanAttribute = new ArrayList<MBeanAttributeInfo>();
            result.key = key;
            return result;
        }
    }
}

