/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.sampler;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.log.Logger;
import org.nudge.probe.sampler.SamplerMBean;
import org.nudge.probe.util.Checker;
import org.nudge.probe.util.ExceptionCounter;

public abstract class LimitSampler
implements SamplerMBean,
Runnable {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private final String name;
    private final String threadName;
    private final ExceptionCounter exceptionCounter;
    private final AtomicBoolean enabled;
    private final AtomicBoolean running;
    private final AtomicBoolean overLimit;
    private final AtomicInteger executionCount;
    private long lastExecutionDurationMillis;
    private long lastExecutionDurationNanos;
    private long lastExecutionTime;
    protected final CurrentTime time;

    protected LimitSampler(String name, CurrentTime time, boolean enabled) {
        Checker.checkArgument(null != name && name.length() > 0);
        this.name = name;
        Checker.checkArgument(null != time);
        this.time = time;
        this.threadName = "nudge-sampler-" + name;
        this.running = new AtomicBoolean(false);
        this.enabled = new AtomicBoolean(enabled);
        this.overLimit = new AtomicBoolean(false);
        this.executionCount = new AtomicInteger(0);
        this.exceptionCounter = new ExceptionCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.enabled.get()) {
            return;
        }
        boolean isRunning = this.running.getAndSet(true);
        int execCount = this.executionCount.incrementAndGet();
        boolean limit = this.overLimit.get();
        if (isRunning) {
            log.finest("%s sampling skipped : running ", this.name);
            return;
        }
        if (limit && execCount % this.getLimitFactor() != 0) {
            log.finest("%s sampling skipped : limit", this.name);
            this.running.set(false);
            return;
        }
        log.finest("%s sampling", this.name);
        long start = this.time.currentTimeMillis();
        long startNanos = this.time.nanoTime();
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        thread.setName(this.threadName);
        try {
            this.sample();
        }
        catch (Exception e) {
            long count = this.exceptionCounter.tick(e.getClass());
            if (count > 0L) {
                log.severe(e, "error while sampling %dx", count);
            }
        }
        finally {
            thread.setName(oldName);
        }
        long total = this.time.currentTimeMillis() - start;
        long totalNanos = this.time.nanoTime() - startNanos;
        this.overLimit.set(total > (long)this.getMaxSampleTime());
        log.finest("%s sampling end : %d ms, %d ns", this.name, total, totalNanos);
        this.lastExecutionTime = start;
        this.lastExecutionDurationMillis = total;
        this.lastExecutionDurationNanos = totalNanos;
        this.running.set(false);
    }

    private int getLimitFactor() {
        return 10;
    }

    public int getInitialDelay() {
        return 5000;
    }

    public abstract int getSampleInterval();

    protected abstract int getMaxSampleTime();

    protected abstract void sample();

    @Override
    public int getSamplePeriod() {
        return this.getSampleInterval();
    }

    @Override
    public int getSampleLimitMillis() {
        return this.getMaxSampleTime();
    }

    @Override
    public long getLastExecutionDurationMillis() {
        return this.lastExecutionDurationMillis;
    }

    @Override
    public long getLastExecutionDurationNanos() {
        return this.lastExecutionDurationNanos;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean active) {
        this.enabled.set(active);
    }

    @Override
    public boolean isLimitActive() {
        return this.overLimit.get();
    }

    @Override
    public void setLimitActive(boolean limit) {
        this.overLimit.set(limit);
    }

    @Override
    public long getLastExecutionTimestamp() {
        return this.lastExecutionTime;
    }
}

