/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.sampler;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.TxUuid;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.sampler.LimitSampler;

public class ProfilingSampler
extends LimitSampler {
    private final Collector collector;
    private final Configuration config;
    private final TxUuid uuid;
    private ThreadMXBean threadMXBean;

    public ProfilingSampler(Collector collector, Configuration config, TxUuid uuid, CurrentTime time) {
        super("profiling", time, config.isProfilingEnabled());
        this.collector = collector;
        this.config = config;
        this.uuid = uuid;
    }

    public void setThreadMXBean(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
    }

    @Override
    protected void sample() {
        if (null == this.threadMXBean) {
            return;
        }
        for (long id : this.threadMXBean.getAllThreadIds()) {
            ThreadInfo info;
            TxUuid.TxThread threadState = this.uuid.getThreadState(id);
            if (threadState == null || (info = this.threadMXBean.getThreadInfo(id, this.config.getProfilingThreadDepth())) == null) continue;
            this.collector.send(ProfilingSampler.buildBuffer(info, threadState.getUuid(), threadState.getMethod(), this.time.currentTimeMillis()));
        }
    }

    @Override
    public int getSampleInterval() {
        return this.config.getProfilingSampleInterval();
    }

    @Override
    protected int getMaxSampleTime() {
        return this.config.getProfilingSampleMaxTime();
    }

    private static RawDataProtocol.ThreadInfo.Builder buildBuffer(ThreadInfo info, String uuid, String url, long ts) {
        RawDataProtocol.ThreadInfo.Builder builder = RawDataProtocol.ThreadInfo.newBuilder();
        builder.setUuid(uuid);
        builder.setUrl(url);
        builder.setTimeStamp(ts);
        builder.setState(RawDataProtocol.ThreadInfo.State.valueOf(info.getThreadState().toString()));
        builder.setWaitedCount(info.getWaitedCount());
        builder.setWaitedTime(-1L);
        builder.setBlockedCount(info.getBlockedCount());
        builder.setBlockedTime(-1L);
        for (StackTraceElement elem : info.getStackTrace()) {
            builder.addFramesBuilder().setClassName(elem.getClassName()).setMethodName(elem.getMethodName()).setLineNumber(elem.getLineNumber());
        }
        return builder;
    }
}

