/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.sampler;

import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.probe.Configuration;
import org.nudge.probe.CurrentTime;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.log.Logger;
import org.nudge.probe.sampler.LimitSampler;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.util.Checker;

public class SystemSampler
extends LimitSampler {
    private static final Logger LOG = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final int INIT_METHOD_SAMPLING = 10;
    private final Collector collector;
    private final NudgeProbe probe;
    private final Configuration config;
    private OperatingSystemMXBean osmxb;
    private ThreadMXBean tmxb;
    private List<SampleState> methodsToSample;
    private int sampleExecutionCount;

    public SystemSampler(Collector collector, NudgeProbe probe, Configuration config, CurrentTime time) {
        super("system", time, config.isSystemMetricsEnabled());
        this.collector = collector;
        this.methodsToSample = new ArrayList<SampleState>();
        this.probe = probe;
        this.config = config;
    }

    public void setup(OperatingSystemMXBean osmxb, ThreadMXBean tmxb) {
        Checker.checkArgument(null != osmxb);
        this.osmxb = osmxb;
        Checker.checkArgument(null != tmxb);
        this.tmxb = tmxb;
    }

    private boolean isSetupDone() {
        return null != this.osmxb && null != this.tmxb;
    }

    @Override
    protected void sample() {
        if (this.sampleExecutionCount < 10) {
            if (this.isSetupDone()) {
                ArrayList<SampleState> list = new ArrayList<SampleState>();
                SampleMethod[] sampleMethodArray = SampleMethod.values();
                int n = sampleMethodArray.length;
                for (int i = 0; i < n; ++i) {
                    PlatformManagedObject target = this.osmxb;
                    SampleMethod sampleMethod = sampleMethodArray[i];
                    Method method = this.getMethodSilently(target, sampleMethod);
                    if (null == method) {
                        target = this.tmxb;
                        method = this.getMethodSilently(target, sampleMethod);
                    }
                    if (null == method) continue;
                    list.add(new SampleState(sampleMethod, target, method));
                }
                this.methodsToSample = list;
            }
        } else if (!this.isSetupDone()) {
            throw new IllegalStateException("sampler not properly set up");
        }
        long timestamp = this.time.currentTimeMillis();
        for (SampleState sampleState : this.methodsToSample) {
            RawDataProtocol.SystemMetricSample sample = sampleState.sample(timestamp);
            if (null == sample) continue;
            this.collector.send(sample);
        }
        for (NudgeProbe.DiskUsage diskUsage : this.probe.getDiskUsage()) {
            RawDataProtocol.SystemMetricSample.Builder builder = RawDataProtocol.SystemMetricSample.newBuilder().setTimestamp(timestamp);
            this.collector.send(builder.setKey("disk.total#" + diskUsage.getPath()).setLongValue(diskUsage.getTotalSpace()).build());
            this.collector.send(builder.setKey("disk.free#" + diskUsage.getPath()).setLongValue(diskUsage.getFreeSpace()).build());
        }
        ++this.sampleExecutionCount;
    }

    private Method getMethodSilently(Object target, SampleMethod sampleMethod) {
        Method method = null;
        Class<?> type = target.getClass();
        try {
            method = type.getMethod(sampleMethod.name(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.finest("no such method '%s' on class '%s'", sampleMethod.name(), type.getName());
        }
        return method;
    }

    @Override
    public int getSampleInterval() {
        return this.config.getSystemSampleInterval();
    }

    @Override
    protected int getMaxSampleTime() {
        return this.config.getSystemSampleMaxTime();
    }

    private static class SampleState {
        private SampleMethod sampleMethod;
        private Method method;
        private Object target;

        private SampleState(SampleMethod sampleMethod, Object target, Method method) {
            this.sampleMethod = sampleMethod;
            this.target = target;
            this.method = method;
        }

        private RawDataProtocol.SystemMetricSample sample(long ts) {
            RawDataProtocol.SystemMetricSample.Builder sample = RawDataProtocol.SystemMetricSample.newBuilder().setKey(this.sampleMethod.key).setTimestamp(ts);
            Object returnValue = null;
            try {
                returnValue = this.method.invoke(this.target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOG.finest("illegal access for method %s", this.method.getName());
            }
            catch (InvocationTargetException e) {
                LOG.finest("invocation target for method %s", this.method.getName());
            }
            RawDataProtocol.SystemMetricSample result = null;
            if (returnValue instanceof Number) {
                Number number = (Number)returnValue;
                if (this.sampleMethod.isDecimal) {
                    sample.setDoubleValue(number.doubleValue());
                } else {
                    sample.setLongValue(number.longValue());
                }
                result = sample.build();
            }
            return result;
        }
    }

    private static enum SampleMethod {
        getSystemLoadAverage("load", true),
        getSystemCpuLoad("cpu.load", true),
        getFreePhysicalMemorySize("mem.free", false),
        getTotalPhysicalMemorySize("mem.total", false),
        getFreeSwapSpaceSize("swap.free", false),
        getTotalSwapSpaceSize("swap.total", false),
        getOpenFileDescriptorCount("proc.fd.open", false),
        getMaxFileDescriptorCount("proc.fd.max", false),
        getProcessCpuLoad("proc.cpu.load", true),
        getThreadCount("proc.thread.count", false);

        final String key;
        final boolean isDecimal;

        private SampleMethod(String key, boolean isDecimal) {
            this.key = key;
            this.isDecimal = isDecimal;
        }
    }
}

