/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.nudge.probe.Configuration;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.spi.NudgeProbe;
import org.nudge.probe.util.Checker;

public class NudgeProbeSpi {
    private static final String PROBE_JAVA5 = "org.nudge.probe.NudgeProbeJava5";
    private static final String PROBE_JAVA6 = "org.nudge.probe.NudgeProbeJava6";

    public static NudgeProbe getProbeSpi(Configuration config, JvmInfo jvmInfo) {
        return NudgeProbeSpi.getProbeSpi(System.getProperty("java.version"), config, jvmInfo);
    }

    public static NudgeProbe getProbeSpi(String javaVersion, Configuration config, JvmInfo jvmInfo) {
        String className = javaVersion.startsWith("1.5") ? PROBE_JAVA5 : PROBE_JAVA6;
        try {
            Class<?> type = Class.forName(className, true, NudgeProbe.class.getClassLoader());
            Checker.checkState(NudgeProbe.class.isAssignableFrom(type));
            Constructor<?> constructor = type.getConstructor(Configuration.class, JvmInfo.class);
            return (NudgeProbe)constructor.newInstance(config, jvmInfo);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("missing runtime dependency: ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

