/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ExceptionCounter {
    private final ConcurrentHashMap<Class<? extends Throwable>, AtomicLong> countMap = new ConcurrentHashMap();

    public long tick(Class<? extends Throwable> t) {
        long value;
        AtomicLong newCount = new AtomicLong(1L);
        AtomicLong count = this.countMap.putIfAbsent(t, newCount);
        if (null != count) {
            count.addAndGet(1L);
            count.compareAndSet(Long.MAX_VALUE, 1L);
        } else {
            count = newCount;
        }
        long currentCount = count.get();
        if (currentCount <= 10L) {
            return currentCount;
        }
        for (value = currentCount; value > 1L; value /= 10L) {
            if (value % 10L <= 0L) continue;
            return -1L;
        }
        return value == 1L ? currentCount : -1L;
    }
}

