/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class LogAnalyzer {
    private static final Map<String, Integer> result = new HashMap<String, Integer>();
    private static final Set<String> known = new HashSet<String>();
    private static final Map<String, String> lastThreadMessage = new HashMap<String, String>();

    public static void packageDistribution(String file) {
        result.put("(all)", 0);
        try {
            Scanner s = new Scanner(new File(file)).useDelimiter("\n");
            while (s.hasNext()) {
                String line = s.next();
                LogAnalyzer.sample(line);
                LogAnalyzer.lastThreadMessage(line);
            }
            ArrayList<Map.Entry<String, Integer>> keys = new ArrayList<Map.Entry<String, Integer>>();
            keys.addAll(result.entrySet());
            Collections.sort(keys, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            System.out.println("Number of classes per package");
            for (Map.Entry entry : keys) {
                System.out.println(entry);
            }
            System.out.println("\nLast Message of each thread");
            ArrayList<Map.Entry<String, String>> names = new ArrayList<Map.Entry<String, String>>();
            names.addAll(lastThreadMessage.entrySet());
            Collections.sort(names, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : names) {
                System.out.println((String)entry.getValue());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void lastThreadMessage(String line) {
        if (!line.contains("checking instrumentability for")) {
            return;
        }
        String[] data = line.split(" \\| ");
        if (data.length < 2) {
            return;
        }
        String threadName = data[0].split(" FINE ")[1];
        lastThreadMessage.put(threadName, line);
    }

    private static void sample(String line) {
        if (line.contains("checking instrumentability for")) {
            int p0 = line.indexOf("checking instrumentability for");
            String clazz = line.substring(p0 + 32);
            if (known.contains(clazz)) {
                return;
            }
            known.add(clazz);
            int p = 0;
            while ((p = clazz.indexOf(47, p + 1)) != -1) {
                String pkg = clazz.substring(0, p);
                Integer v = result.get(pkg);
                if (v == null) {
                    v = 0;
                }
                result.put(pkg, v + 1);
            }
            result.put("(all)", result.get("(all)") + 1);
        }
    }
}

