/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.io.OutputStream;
import java.util.zip.Checksum;
import org.nudge.dependency.nj.lz4.LZ4BlockOutputStream;
import org.nudge.dependency.nj.lz4.LZ4Compressor;
import org.nudge.dependency.nj.lz4.LZ4Factory;
import org.nudge.dependency.nj.xxhash.XXHashFactory;

public class Lz4 {
    public static final String LZ4_FILE_EXTENSION = "lz4";
    public static String LZ4_MIME_TYPE = "application/x-lz4-compressed";
    private static final int LZ4_SEED = -1756908916;
    private static final int LZ4_BLOCK_SIZE = 65536;
    private static final LZ4Compressor lz4Compressor;
    private static final Checksum checksum;

    private Lz4() {
    }

    public static OutputStream compressOutputStream(OutputStream output) {
        return new LZ4BlockOutputStream(output, 65536, lz4Compressor, checksum, false);
    }

    static {
        LZ4Factory lz4Factory = LZ4Factory.fastestJavaInstance();
        lz4Compressor = lz4Factory.fastCompressor();
        checksum = XXHashFactory.fastestJavaInstance().newStreamingHash32(-1756908916).asChecksum();
    }
}

