/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.nudge.dependency.cnab.probe.RawDataProtocol;

public class Rawdata2String {
    private static final char SEPARATOR = '\t';

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("use first argument to specify which rawdata file should be parsed and printed");
        } else {
            File f = new File(args[0]);
            File[] files = f.isDirectory() ? f.listFiles() : new File[]{f};
            for (File file : files) {
                FileInputStream is = new FileInputStream(file);
                RawDataProtocol.RawData.Builder rawdata = RawDataProtocol.RawData.parseFrom(is).toBuilder();
                ((InputStream)is).close();
                if (rawdata.hasSegmentDictionary()) {
                    Map<Integer, String> segmentDict = Rawdata2String.getMapByDict(rawdata.getSegmentDictionary());
                    for (RawDataProtocol.Transaction.Builder tr : rawdata.getTransactionsBuilderList()) {
                        String name = segmentDict.get(tr.getUrlID());
                        if (name == null) continue;
                        tr.setUrl(name);
                    }
                }
                for (RawDataProtocol.Transaction.Builder t : rawdata.getTransactionsBuilderList()) {
                    if (!t.hasSessionId() || t.getSessionId().equals("")) continue;
                    StringBuilder b = new StringBuilder();
                    b.append(file.getName());
                    b.append('\t');
                    b.append(t.getSessionId());
                    b.append('\t');
                    b.append(t.getUrl());
                    b.append('\t');
                    b.append(t.getStartTime());
                    b.append('\t');
                    b.append(t.getStatus());
                    b.append('\t');
                    b.append(t.getUserIp());
                    b.append('\t');
                    b.append(t.getRespStatusCode());
                    b.append('\t');
                    b.append(t.getReqMethod());
                    b.append('\t');
                    b.append(t.getMethodName());
                    System.out.println(b.toString());
                }
            }
        }
    }

    private static Map<Integer, String> getMapByDict(RawDataProtocol.Dictionary segmentDictionary) {
        HashMap<Integer, String> segmentDict = new HashMap<Integer, String>();
        for (RawDataProtocol.Dictionary.DictionaryEntry d : segmentDictionary.getDictionaryList()) {
            segmentDict.put(d.getId(), d.getName());
        }
        return segmentDict;
    }
}

