/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nudge.dependency.cgg.Gson;
import org.nudge.dependency.cnab.probe.RawDataProtocol;

public class RawdataReader {
    private static final String DATADOG_TRACE_HEADER = "http.request.header.x-ddtrace-parent_trace_id";
    private static final String DATADOG_SPAN_HEADER = "http.request.header.x-ddtrace-parent_span_id";

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("use first argument to specify which rawdata file should be parsed and printed");
        } else if (args.length > 1) {
            RawdataReader.printSysRawdata(args[0]);
        } else {
            RawdataReader.printAppRawdata(args[0]);
        }
    }

    public static RawDataProtocol.RawData applyDictionary(RawDataProtocol.RawData source) {
        String url;
        RawDataProtocol.RawData.Builder rawdata = source.toBuilder();
        if (rawdata.hasSegmentDictionary()) {
            Map<Integer, String> segmentDict = RawdataReader.getMapByDict(rawdata.getSegmentDictionary());
            for (RawDataProtocol.Transaction.Builder tr : rawdata.getTransactionsBuilderList()) {
                String name = segmentDict.get(tr.getUrlID());
                if (name == null) continue;
                tr.setUrl(name);
            }
        }
        if (rawdata.hasJmsDictionary()) {
            Map<Integer, String> jmsDict = RawdataReader.getMapByDict(rawdata.getJmsDictionary());
            for (RawDataProtocol.Transaction.Builder tr : rawdata.getTransactionsBuilderList()) {
                String queue;
                for (RawDataProtocol.JMSMessage.Builder j : tr.getConsumedJMSBuilderList()) {
                    queue = jmsDict.get(j.getQueueId());
                    if (queue != null) {
                        j.setQueueName(queue);
                    }
                    if ((url = jmsDict.get(j.getUrlId())) == null) continue;
                    j.setUrlName(url);
                }
                for (RawDataProtocol.JMSMessage.Builder j : tr.getProducedJMSBuilderList()) {
                    queue = jmsDict.get(j.getQueueId());
                    if (queue != null) {
                        j.setQueueName(queue);
                    }
                    if ((url = jmsDict.get(j.getUrlId())) == null) continue;
                    j.setUrlName(url);
                }
            }
        }
        if (rawdata.hasQueryDictionary()) {
            Map<Integer, String> qryDict = RawdataReader.getMapByDict(rawdata.getQueryDictionary());
            for (RawDataProtocol.Transaction.Builder tr : rawdata.getTransactionsBuilderList()) {
                for (RawDataProtocol.SqlRequest.Builder sql : tr.getSqlRequestsBuilderList()) {
                    String query = qryDict.get(sql.getSqlId());
                    if (query != null) {
                        sql.setSql(query);
                    }
                    if ((url = qryDict.get(sql.getUrlId())) == null) continue;
                    sql.setServerUrl(url);
                }
            }
        }
        if (rawdata.hasUserAgent()) {
            Map<Integer, String> agentDict = RawdataReader.getMapByDict(rawdata.getUserAgent());
            for (RawDataProtocol.Transaction.Builder tr : rawdata.getTransactionsBuilderList()) {
                String agent = agentDict.get(tr.getUseragentID());
                if (agent == null) continue;
                tr.setUserAgent(agent);
            }
        }
        if (rawdata.hasMbeanDictionary()) {
            Map<Integer, String> mbeanDict = RawdataReader.getMapByDict(rawdata.getMbeanDictionary());
            for (RawDataProtocol.MBean.Builder mb : rawdata.getMBeanBuilderList()) {
                for (RawDataProtocol.MBeanAttributeInfo.Builder mba : mb.getAttributeInfoBuilderList()) {
                    String desc;
                    String type;
                    String name = mbeanDict.get(mba.getNameId());
                    if (name != null) {
                        mba.setName(name);
                    }
                    if ((type = mbeanDict.get(mba.getTypeId())) != null) {
                        mba.setType(type);
                    }
                    if ((desc = mbeanDict.get(mba.getDescriptionId())) == null) continue;
                    mba.setDescription(desc);
                }
            }
        }
        if (rawdata.hasClassDictionary()) {
            Map<Integer, String> classDict = RawdataReader.getMapByDict(rawdata.getClassDictionary());
            Map<Integer, String> methodDict = RawdataReader.getMapByDict(rawdata.getMethodDictionary());
            for (RawDataProtocol.ThreadInfo.Builder info : rawdata.getThreadInfosBuilderList()) {
                for (RawDataProtocol.ThreadInfo.StackTraceElement.Builder ste : info.getFramesBuilderList()) {
                    String method;
                    String className = classDict.get(ste.getClassNameId());
                    if (className != null) {
                        ste.setClassName(className);
                    }
                    if ((method = methodDict.get(ste.getMethodNameId())) == null) continue;
                    ste.setMethodName(method);
                }
            }
        }
        return rawdata.build();
    }

    private static Map<Integer, String> getMapByDict(RawDataProtocol.Dictionary segmentDictionary) {
        HashMap<Integer, String> segmentDict = new HashMap<Integer, String>();
        for (RawDataProtocol.Dictionary.DictionaryEntry d : segmentDictionary.getDictionaryList()) {
            segmentDict.put(d.getId(), d.getName());
        }
        return segmentDict;
    }

    public static void printAppRawdata(String file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        RawDataProtocol.RawData rawdata = RawDataProtocol.RawData.parseFrom(is);
        ((InputStream)is).close();
        rawdata = RawdataReader.applyDictionary(rawdata);
        System.out.println(rawdata.toString());
    }

    public static void convertToDatadogTraces(String file, boolean packerFormat, String output) throws IOException {
        PrintStream os = output == null ? System.out : new PrintStream(output);
        FileInputStream is = new FileInputStream(file);
        RawDataProtocol.RawData rawdata = RawDataProtocol.RawData.parseFrom(is);
        ((InputStream)is).close();
        rawdata = RawdataReader.applyDictionary(rawdata);
        ArrayList traces = new ArrayList();
        long traceId = System.currentTimeMillis();
        long spanId = 0L;
        for (RawDataProtocol.Transaction t : rawdata.getTransactionsList()) {
            ArrayList spans = new ArrayList();
            ++traceId;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("service", rawdata.getHostname());
            hashMap.put("resource", t.getCode());
            hashMap.put("start", t.getStartTime() * 1000000L);
            hashMap.put("duration", (t.getEndTime() - t.getStartTime()) * 1000000L);
            hashMap.put("error", 0);
            HashMap<String, String> meta = new HashMap<String, String>();
            for (RawDataProtocol.KeyValue extCode : t.getExtendedCodesList()) {
                meta.put(extCode.getKey(), extCode.getValue());
            }
            Number mainTraceId = meta.containsKey(DATADOG_TRACE_HEADER) ? new BigInteger((String)meta.get(DATADOG_TRACE_HEADER)) : Long.valueOf(traceId);
            hashMap.put("trace_id", mainTraceId);
            hashMap.put("parent_id", meta.containsKey(DATADOG_SPAN_HEADER) ? new BigInteger((String)meta.get(DATADOG_SPAN_HEADER)) : null);
            long mainSpanId = ++spanId;
            hashMap.put("span_id", mainSpanId);
            hashMap.put("name", meta.containsKey("http.method") ? (String)meta.get("http.method") + " " + t.getCode() : (t.hasMethodName() ? t.getMethodName() : (t.hasReqMethod() ? t.getReqMethod() + t.getUrl() : t.getUrl())));
            hashMap.put("meta", meta);
            for (RawDataProtocol.Layer l : t.getLayersList()) {
                if (l.getTime() == 0L) continue;
                String extCodeService = "SQL".equals(l.getLayerName()) ? "jdbc.url" : ("JMS".equals(l.getLayerName()) ? "jms.destination" : ("JAX-WS".equals(l.getLayerName()) ? "jaxws.endpoint" : null));
                for (RawDataProtocol.LayerDetail c : l.getCallsList()) {
                    if (c.getTime() == 0L) continue;
                    HashMap<String, Object> spanMap = new HashMap<String, Object>();
                    HashMap<String, String> extMap = new HashMap<String, String>();
                    for (RawDataProtocol.KeyValue extCode : c.getExtCodesList()) {
                        extMap.put(extCode.getKey(), extCode.getValue());
                    }
                    String service = extCodeService == null ? l.getLayerName() : (extMap.containsKey(extCodeService) ? (String)extMap.get(extCodeService) : l.getLayerName());
                    long start = Math.max(c.getTimestamp(), t.getStartTime()) * 1000000L;
                    long meantime = (long)(1000000.0 * (double)c.getTime() / (double)c.getCount());
                    spanMap.put("service", service);
                    spanMap.put("name", c.getCode().length() < 100 ? c.getCode() : c.getCode().substring(0, 100));
                    spanMap.put("resource", c.getCode());
                    spanMap.put("trace_id", mainTraceId);
                    spanMap.put("duration", meantime);
                    spanMap.put("error", 0);
                    spanMap.put("parent_id", mainSpanId);
                    for (long i = 0L; i < c.getCount(); ++i) {
                        spanMap.put("span_id", ++spanId);
                        spanMap.put("start", start += meantime);
                        spans.add(new HashMap(spanMap));
                    }
                }
            }
            spans.add(hashMap);
            traces.add(spans);
        }
        if (!packerFormat) {
            ArrayList<String> jsonTraces = new ArrayList<String>();
            Gson gson = new Gson();
            for (List list : traces) {
                jsonTraces.add(gson.toJson(list));
            }
            os.println(jsonTraces);
        }
        os.flush();
        if (output != null) {
            os.close();
        }
    }

    public static void printSysRawdata(String file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        RawDataProtocol.RawData rawdata = RawDataProtocol.RawData.parseFrom(is);
        System.out.println(rawdata.toString());
        ((InputStream)is).close();
    }
}

