/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.nudge.dependency.cnab.probe.RawDataProtocol;

public class RawdataUtil {
    private RawdataUtil() {
    }

    public static void writeException(Throwable throwable, RawDataProtocol.Transaction.Builder transaction) {
        if (transaction.getErrorsCount() != 0) {
            return;
        }
        RawDataProtocol.Error.Builder error = RawDataProtocol.Error.newBuilder();
        String name = throwable.getClass().getSimpleName();
        error.setCode(name);
        String msg = throwable.getMessage();
        error.setMessage(msg != null ? msg : "");
        StringBuffer buf = new StringBuffer(500);
        int i = 0;
        for (StackTraceElement ste : throwable.getStackTrace()) {
            if (i > 25) break;
            if (i > 0) {
                buf.append("#");
            }
            buf.append(ste.getClassName());
            buf.append(".");
            buf.append(ste.getMethodName());
            buf.append(" (");
            buf.append(ste.getLineNumber());
            buf.append(")");
            ++i;
        }
        error.setStacktrace(buf.toString());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        error.setJvmStacktrace(sw.toString());
        error.setStartTime(System.currentTimeMillis());
        transaction.addErrors(error);
        transaction.setStatus(RawDataProtocol.Transaction.Status.KO);
    }
}

