/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nudge.dependency.cgp.AbstractMessage;
import org.nudge.dependency.cgp.Descriptors;
import org.nudge.dependency.cnab.probe.RawDataProtocol;
import org.nudge.dependency.oaci.FileUtils;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.probe.util.Holder;
import org.nudge.probe.util.RawdataReader;

public class RawdataViewer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewRawdata(List<String> files, boolean system) throws IOException {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        for (String fileName : files) {
            FileInputStream is = null;
            try {
                RawDataProtocol.RawData r;
                is = new FileInputStream(fileName);
                if (system) {
                    r = RawDataProtocol.RawData.parseFrom(is);
                } else {
                    RawDataProtocol.RawData rawdata = RawDataProtocol.RawData.parseFrom(is);
                    r = RawdataReader.applyDictionary(rawdata);
                }
                File file = new File(fileName);
                treeRoot.add(RawdataViewer.createNodes(Node.buildTreeFromRawdata(String.format("%s - %s", fileName, FileUtils.byteCountToDisplaySize(file.length())), r)));
            }
            catch (IOException e) {
                try {
                    System.out.println(String.format("unable to open file %s", fileName));
                    e.printStackTrace(System.err);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                continue;
            }
            IOUtils.closeQuietly(is);
        }
        RawdataViewer.edit(treeRoot);
    }

    private static DefaultMutableTreeNode createNodes(Node parent) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(parent);
        for (Node child : parent.getChildren()) {
            treeNode.add(RawdataViewer.createNodes(child));
        }
        return treeNode;
    }

    private static void edit(final DefaultMutableTreeNode treeRoot) {
        SwingUtilities.invokeLater(new Runnable(){
            private JTree tree;
            private JLabel statusBar;

            @Override
            public void run() {
                this.createAndShowGUI();
            }

            private void createAndShowGUI() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.err.println("Couldn't use system look and feel.");
                }
                JFrame frame = new JFrame("Rawdata structure");
                this.tree = new JTree(treeRoot);
                this.tree.setShowsRootHandles(false);
                this.tree.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 33) {
                            TreePath path = new TreePath(treeRoot);
                            tree.setSelectionPath(path);
                            tree.scrollPathToVisible(path);
                        }
                    }
                });
                JScrollPane jsp = new JScrollPane(this.tree);
                frame.setDefaultCloseOperation(3);
                frame.add((Component)jsp, "Center");
                frame.add(this.createSearchButton(), "North");
                this.statusBar = new JLabel("[]");
                frame.add((Component)this.statusBar, "South");
                frame.pack();
                frame.setSize(800, 600);
                jsp.requestFocusInWindow();
                frame.setVisible(true);
                frame.setLocationRelativeTo(null);
            }

            private Component createSearchButton() {
                final Holder<Boolean> onceFocused = new Holder<Boolean>(false);
                final JTextField search = new JTextField("Search ...");
                final Color defaultColor = search.getForeground();
                search.setForeground(Color.GRAY);
                search.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (!((Boolean)onceFocused.get()).booleanValue()) {
                            onceFocused.set(true);
                            search.setText("");
                            search.setForeground(defaultColor);
                        }
                    }
                });
                search.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            TreePath path = this.find(treeRoot, search.getText());
                            if (path != null) {
                                statusBar.setText(path.toString());
                            } else {
                                statusBar.setText("Not found");
                            }
                            tree.setSelectionPath(path);
                            tree.scrollPathToVisible(path);
                        }
                    }

                    private TreePath find(DefaultMutableTreeNode root, String s) {
                        DefaultMutableTreeNode node;
                        Enumeration<TreeNode> e = root.depthFirstEnumeration();
                        boolean found = false;
                        while (e.hasMoreElements()) {
                            node = (DefaultMutableTreeNode)e.nextElement();
                            if (node != tree.getLastSelectedPathComponent()) continue;
                            found = true;
                            break;
                        }
                        if (found && e.hasMoreElements()) {
                            e.nextElement();
                        } else {
                            e = root.depthFirstEnumeration();
                        }
                        while (e.hasMoreElements()) {
                            node = (DefaultMutableTreeNode)e.nextElement();
                            if (!node.toString().contains(s)) continue;
                            return new TreePath(node.getPath());
                        }
                        return null;
                    }
                });
                return search;
            }
        });
    }

    private static class Node {
        private final List<Node> children;
        private final String value;
        private final String name;
        private final int parentIndex;
        private final boolean deprecated;
        private final Node parent;

        private Node(Node parent, String name, String value, boolean deprecated) {
            this.parent = parent;
            this.children = new ArrayList<Node>();
            this.value = value;
            this.name = name;
            this.deprecated = deprecated;
            if (null == parent) {
                this.parentIndex = -1;
            } else {
                this.parentIndex = parent.children.size();
                parent.children.add(this);
            }
        }

        public String toString() {
            String result = this.children.isEmpty() ? (null == this.value ? this.name : String.format("%s = %s", this.name, this.value)) : (null != this.parent && this.parent.name.equals(this.name) ? String.format("#%d --- %s", this.parentIndex, this.children.get(0).toString()) : String.format("%s    (%d)", this.name, this.children.size()));
            if (this.deprecated) {
                result = result + "     .";
            }
            return result;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public static Node buildTreeFromRawdata(String rootName, AbstractMessage r) {
            Node root = new Node(null, rootName, null, false);
            Node.buildFromFields(root, r);
            return root;
        }

        private static void buildRecursive(Node parent, Descriptors.FieldDescriptor fieldDescriptor, Object objectValue) {
            String value = objectValue instanceof AbstractMessage ? null : objectValue.toString();
            boolean deprecated = fieldDescriptor.getOptions().getDeprecated();
            Node node = new Node(parent, fieldDescriptor.getName(), value, deprecated);
            if (objectValue instanceof AbstractMessage) {
                Node.buildFromFields(node, (AbstractMessage)objectValue);
            } else if (objectValue instanceof Collection) {
                Collection collection = (Collection)objectValue;
                for (Object o : collection) {
                    Node.buildRecursive(node, fieldDescriptor, o);
                }
            }
        }

        private static void buildFromFields(Node root, AbstractMessage r) {
            Map<Descriptors.FieldDescriptor, Object> allFields = r.getAllFields();
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : allFields.entrySet()) {
                Node.buildRecursive(root, entry.getKey(), entry.getValue());
            }
        }
    }
}

