/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.watch;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.nudge.probe.Configuration;
import org.nudge.probe.ProbeJar;
import org.nudge.probe.log.Logger;

public class WatchFile
implements Runnable {
    private static final Logger log = Logger.getLogger(WatchFile.class.getName());
    private static Configuration configuration;

    public WatchFile(Configuration configuration) {
        WatchFile.configuration = configuration;
    }

    public static void watchFolder() {
        try {
            WatchKey key;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            String properties = configuration.getPropertiesPath();
            if (properties == null) {
                log.warning("No properties file found to watch", new Object[0]);
                return;
            }
            Path path = Paths.get(properties, new String[0]).getParent();
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            log.info("STARTING WATCH : folder path : " + path, new Object[0]);
            while ((key = watchService.take()) != null) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!event.context().toString().equals(Configuration.NUDGE_PROPERTIES)) continue;
                    log.info("BEGINNING LOAD NEW CONFIGURATION", new Object[0]);
                    Configuration newConfig = WatchFile.reloadAllConfiguration();
                    if (newConfig != null) {
                        WatchFile.setNewConfiguration(newConfig);
                    }
                    log.info("NEW CONFIGURATION LOADED", new Object[0]);
                }
                key.reset();
            }
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        WatchFile.watchFolder();
    }

    public static synchronized Configuration reloadAllConfiguration() {
        Configuration configuration = null;
        try {
            configuration = Configuration.buildFromSystemProperties(System.getProperties(), ProbeJar.fromPackaging(), true);
        }
        catch (Exception e) {
            log.config("ERROR WHEN CREATING THE NEW CONFIGURATION", new Object[0]);
        }
        return configuration;
    }

    public static void setNewConfiguration(Configuration configuration) {
        try {
            WatchFile.configuration.setCompressed(configuration.isCompressed());
            WatchFile.configuration.setPrependTxType(configuration.prependTxTypeToUrl());
            WatchFile.configuration.setAllowInstanceConfig(configuration.isAllowedInstanceConfig());
            WatchFile.configuration.setDiskFallbackMaxSend(configuration.getDiskFallbackMaxSend());
            WatchFile.configuration.setDiskFallbackIgnoreThreshold(configuration.getDiskFallbackIgnoreThreshold());
            WatchFile.configuration.setDiskFallbackMaxSize(configuration.getDiskFallbackMaxSize());
            WatchFile.configuration.setDiskDumpMaxSize(configuration.getDiskDumpMaxSize());
            WatchFile.configuration.setDiskFallbackDirectory(configuration.getDiskFallbackDirectory());
            WatchFile.configuration.setDiskDumpDirectory(configuration.getDiskDumpDirectory());
            WatchFile.configuration.setQualifier(configuration.getServiceQualifier());
            WatchFile.configuration.setHostKey(configuration.getHostKey());
            WatchFile.configuration.setCaptureHttpParams(configuration.isParamsAllowed());
            WatchFile.configuration.setIgnoredHttpParams(configuration.getIgnoredHttpParams());
            WatchFile.configuration.setAllowedHttpParams(configuration.getAllowedHttpParams());
            WatchFile.configuration.setCaptureHttpHeaders(configuration.isHeadersAllowed());
            WatchFile.configuration.setIgnoredHttpHeaders(configuration.getIgnoredHttpHeaders());
            WatchFile.configuration.setAllowedHttpHeaders(configuration.getAllowedHttpHeaders());
            WatchFile.configuration.setHttpClientIp(configuration.isCaptureHttpClientIp());
            WatchFile.configuration.setMbeansMonitored(configuration.getMbeansMonitored());
            WatchFile.configuration.setInitialMbeansMonitored(configuration.getMbeansMonitored());
            WatchFile.configuration.setMaxMbeanAttributesMonitored(configuration.getMaxMbeanAttributesMonitored());
            WatchFile.configuration.setSystemSampleMaxTime(configuration.getSystemSampleMaxTime());
            WatchFile.configuration.setProfilingThreadDepth(configuration.getProfilingThreadDepth());
            WatchFile.configuration.setProfilingSampleMaxTime(configuration.getProfilingSampleMaxTime());
            WatchFile.configuration.setInstrumentProxyClasses(configuration.isInstrumentProxyClasses());
        }
        catch (Exception e) {
            log.info("THE NEW CONFIGURATION HAS NOT BEEN LOADED", new Object[0]);
            log.info("JAVA PROBE STILL RUNNING WITH THE LAST CONFIGURATION", new Object[0]);
            e.printStackTrace();
        }
    }
}

