/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import org.nudge.dependency.ooa.ClassReader;
import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.commons.GeneratorAdapter;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.AsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;
import org.nudge.probe.weave.NudgeClassVisitor;
import org.nudge.probe.weave.NudgeClassWriter;

public abstract class AbstractAsmWeaver
extends AbstractWeaver
implements AsmWeaver {
    private static final Logger log = Logger.getLogger(AbstractAsmWeaver.class.getName());
    private final String type;
    private final String handlerClass;

    protected AbstractAsmWeaver(String type, String handlerClass) {
        Checker.checkArgument(null != type && type.length() > 0, "type should not be empty or null");
        Checker.checkArgument(null != handlerClass && handlerClass.length() > 0, "type should not be empty or null");
        this.type = type;
        this.handlerClass = handlerClass;
    }

    @Override
    public boolean useAsmInstrumentation() {
        return true;
    }

    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
    }

    @Override
    public int addClassFieldsSize() {
        return 0;
    }

    @Override
    public void addClassField(ClassDef type, int i, ClassVisitor cv) {
    }

    @Override
    public int contextFieldsSize() {
        return 0;
    }

    @Override
    public void contextFieldLoadValue(ClassDef type, MethodDef method, int i, GeneratorAdapter mv, ClassLoader classLoader) {
        mv.visitInsn(1);
    }

    @Override
    public final byte[] instrument(byte[] classBytes, String className, ClassLoader cl) {
        Checker.checkArgument(null != cl);
        this.beforeInstrument(classBytes, className, cl);
        ClassReader reader = new ClassReader(classBytes);
        ClassDef classDef = null;
        try {
            classDef = ClassDef.fromClassLoaderResource(className, cl);
        }
        catch (RuntimeException e) {
            log.fine(e, "unable to load class from classloader resource, fallback to using provided bytecode %s", className);
        }
        if (null == classDef) {
            try {
                classDef = ClassDef.fromBytecode(classBytes, cl);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("unable to read class from provided bytecode " + className, e);
            }
        }
        NudgeClassWriter writer = new NudgeClassWriter(cl, classDef, 3);
        reader.accept(new NudgeClassVisitor(cl, classDef, writer, this), 4);
        try {
            return writer.toByteArray();
        }
        catch (RuntimeException e) {
            log.severe("unable to instrument class with %s, method/class probably too large : %s", this.getClass().getSimpleName(), className);
            return null;
        }
    }

    @Override
    public final boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        throw new IllegalStateException("this weaver uses ASM instrumentation");
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return true;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHandlerClass() {
        return this.handlerClass;
    }
}

