/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import java.util.Arrays;
import java.util.LinkedList;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.ClassPool;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtField;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.CtNewMethod;
import org.nudge.javassist.CtPrimitiveType;
import org.nudge.javassist.Modifier;
import org.nudge.javassist.NotFoundException;
import org.nudge.javassist.bytecode.BadBytecode;
import org.nudge.javassist.bytecode.MethodInfo;
import org.nudge.probe.EventType;
import org.nudge.probe.ProxyClassLoader;
import org.nudge.probe.jvm.JvmInfo;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.ServerMetadata;

public abstract class AbstractWeaver {
    private static final Logger log = Logger.getLogger(AbstractWeaver.class.getName());
    private final JvmInfo jvmInfo;

    public AbstractWeaver() {
        this.jvmInfo = null;
    }

    public AbstractWeaver(JvmInfo jvmInfo) {
        Checker.checkArgument(null != jvmInfo);
        this.jvmInfo = jvmInfo;
    }

    protected JvmInfo getJvmInfo() {
        return this.jvmInfo;
    }

    public abstract boolean matches(ClassDef var1, ClassLoader var2);

    public abstract boolean instrument(CtMethod var1) throws CannotCompileException, NotFoundException;

    public final void instrument(CtClass cc) throws CannotCompileException, NotFoundException {
        if (!this.beforeInstrument(cc)) {
            return;
        }
        CtMethod[] methods = cc.getDeclaredMethods();
        if (methods == null) {
            return;
        }
        for (CtMethod m : methods) {
            MethodInfo methodInfo;
            CtMethod method = cc.getMethod(m.getName(), m.getSignature());
            if (method == null || !(methodInfo = method.getMethodInfo()).isMethod() || Modifier.isNative(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || method.getName().equals("toString") || method.getName().equals("hashCode") || method.getName().equals("equals") || !method.getDeclaringClass().getName().equals(cc.getName())) continue;
            boolean instrumented = this.instrument(method);
            if (instrumented && log.isLoggable(Level.FINEST)) {
                log.finest(" %s instrumentation method %s %s %s", this.getClass().getSimpleName(), cc.getName(), method.getName(), method.getSignature());
            }
            try {
                methodInfo.rebuildStackMapIf6(cc.getClassPool(), cc.getClassFile());
            }
            catch (BadBytecode badBytecode) {
                log.info(badBytecode, "unable to rebuild stackmap frame");
            }
        }
    }

    public byte[] instrument(byte[] classBytes, String className, ClassLoader cl) {
        return classBytes;
    }

    public boolean useAsmInstrumentation() {
        return false;
    }

    protected boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        return true;
    }

    @Deprecated
    protected void addCatch(CtMethod method) throws NotFoundException, CannotCompileException {
        this.addCatch(method, null, null);
    }

    protected void addCatch(CtMethod method, String handlerClass, String type) throws NotFoundException, CannotCompileException {
        boolean oldMode = null == handlerClass && null == type;
        LinkedList<CtClass> exceptions = new LinkedList<CtClass>();
        exceptions.addAll(Arrays.asList(method.getExceptionTypes()));
        ClassPool classPool = method.getDeclaringClass().getClassPool();
        CtClass throwable = classPool.makeClass(Throwable.class.getName());
        exceptions.addLast(throwable);
        for (CtClass exception : exceptions) {
            StringBuilder buf = new StringBuilder();
            buf.append("{ ");
            if (oldMode) {
                buf.append(" org.nudge.probe.LoggerFactory.getLogger()");
                buf.append("   .log($e); ");
            } else {
                this.createNewEvent(method, handlerClass, type, buf);
                buf.append("     .thrownException($e).exiting();");
            }
            buf.append("   throw $e; ");
            buf.append("} ");
            method.addCatch(buf.toString(), exception);
        }
    }

    protected void wrapMethod(CtMethod method, String handlerClass, String type) throws NotFoundException, CannotCompileException {
        Checker.checkArgument(null != method);
        Checker.checkArgument(null != type);
        ProxyClassLoader.addClass(handlerClass);
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        this.createNewEvent(method, handlerClass, type, buf);
        buf.append(".entering();");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method, handlerClass, type);
        buf = new StringBuilder();
        buf.append("{ ");
        this.createNewEvent(method, handlerClass, type, buf);
        CtClass methodReturnType = method.getReturnType();
        if (methodReturnType != null && !"void".equals(methodReturnType.getName())) {
            CtClass returnType = methodReturnType;
            buf.append(String.format(".returnValue(%s)", this.wrapPrimitiveIfRequired(returnType, "$_")));
        }
        buf.append(".exiting();");
        buf.append("} ");
        method.insertAfter(buf.toString(), false);
    }

    private void createNewEvent(CtMethod method, String handlerClass, String type, StringBuilder buf) throws NotFoundException {
        buf.append("org.nudge.probe.LoggerFactory.getLogger().newEvent(" + method.getDeclaringClass().getName() + ".class.getClassLoader())");
        if (null != handlerClass) {
            buf.append(".handler(\"" + handlerClass + "\")");
        }
        buf.append(".type(\"" + type + "\")");
        if ((method.getModifiers() & 8) == 0) {
            buf.append(".methodTarget($0)");
        }
        this.addMethodAndArguments(method, buf);
    }

    private void addMethodAndArguments(CtMethod method, StringBuilder buf) throws NotFoundException {
        buf.append(".method(\"" + method.getLongName() + "\")");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String paramValue = "$" + (i + 1);
            CtClass paramType = method.getParameterTypes()[i];
            paramValue = this.wrapPrimitiveIfRequired(paramType, paramValue);
            buf.append(".methodParam(" + paramValue + ")");
        }
    }

    private String wrapPrimitiveIfRequired(CtClass paramType, String paramValue) {
        if (paramType.isPrimitive() && paramType instanceof CtPrimitiveType) {
            String wrapperName = ((CtPrimitiveType)paramType).getWrapperName();
            return String.format("%s.valueOf(%s)", wrapperName, paramValue);
        }
        return paramValue;
    }

    protected void exiting(CtMethod method, String code, EventType eventType) throws CannotCompileException {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger nudge = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  nudge.exiting(").append(AbstractWeaver.toClassName(eventType));
        buf.append(",\"").append(code).append("\"");
        buf.append(");");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }

    private static String toClassName(Enum<?> event) {
        return event.getClass().getCanonicalName().replaceAll("/", ".") + "." + event.name();
    }

    protected void buildServerMetadata(CtClass clazz) throws NotFoundException, CannotCompileException {
        if (clazz.getInterfaces() != null) {
            for (CtClass ctClass : clazz.getInterfaces()) {
                if (!ServerMetadata.class.getName().equals(ctClass.getName())) continue;
                return;
            }
        }
        clazz.addField(CtField.make("private java.lang.String nudgeProductName;", clazz));
        String setNudgeProductName = "public void setNudgeProductName(String name) { this.nudgeProductName = name; } ";
        String getNudgeProductName = "public java.lang.String getNudgeProductName() { return this.nudgeProductName; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeProductName, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeProductName, clazz));
        clazz.addField(CtField.make("private java.lang.String nudgeProductVersion;", clazz));
        String setNudgeProductVersion = "public void setNudgeProductVersion(String version) { this.nudgeProductVersion = version; } ";
        String getNudgeProductVersion = "public java.lang.String getNudgeProductVersion() { return this.nudgeProductVersion; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeProductVersion, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeProductVersion, clazz));
        clazz.addField(CtField.make("private java.lang.String nudgeHostName;", clazz));
        String setNudgeHostName = "public void setNudgeHostName(String host) { this.nudgeHostName = host; } ";
        String getNudgeHostName = "public java.lang.String getNudgeHostName() { return this.nudgeHostName; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeHostName, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeHostName, clazz));
        clazz.addField(CtField.make("private java.lang.String nudgeHostAddress;", clazz));
        String setNudgeHostAddress = "public void setNudgeHostAddress(String ip) { this.nudgeHostAddress = ip; } ";
        String getNudgeHostAddress = "public java.lang.String getNudgeHostAddress() { return this.nudgeHostAddress; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeHostAddress, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeHostAddress, clazz));
        clazz.addField(CtField.make("private int nudgePort;", clazz));
        String setNudgePort = "public void setNudgePort(int port) { this.nudgePort = port; } ";
        String getNudgePort = "public int getNudgePort() { return this.nudgePort; } ";
        clazz.addMethod(CtNewMethod.make(setNudgePort, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgePort, clazz));
        clazz.addField(CtField.make("private java.lang.String nudgeDriverName;", clazz));
        String setNudgeDriverName = "public void setNudgeDriverName(String name) { this.nudgeDriverName = name; } ";
        String getNudgeDriverName = "public java.lang.String getNudgeDriverName() { return this.nudgeDriverName; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeDriverName, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeDriverName, clazz));
        clazz.addField(CtField.make("private java.lang.String nudgeDriverVersion;", clazz));
        String setNudgeDriverVersion = "public void setNudgeDriverVersion(String version) { this.nudgeDriverVersion = version; } ";
        String getNudgeDriverVersion = "public java.lang.String getNudgeDriverVersion() { return this.nudgeDriverVersion; } ";
        clazz.addMethod(CtNewMethod.make(setNudgeDriverVersion, clazz));
        clazz.addMethod(CtNewMethod.make(getNudgeDriverVersion, clazz));
        clazz.addInterface(clazz.getClassPool().get(ServerMetadata.class.getName()));
    }

    protected static boolean isFinal(CtMethod m) {
        return Modifier.isFinal(m.getModifiers());
    }

    protected static void addInterface(String name, CtClass clazz) throws CannotCompileException, NotFoundException {
        boolean isPresent = false;
        for (CtClass ctClass : clazz.getInterfaces()) {
            isPresent = isPresent || ctClass.getName().equals(name);
        }
        if (!isPresent) {
            clazz.addInterface(clazz.getClassPool().get(name));
        }
    }

    protected static void addField(String def, CtClass clazz) throws CannotCompileException {
        CtField field = CtField.make(def, clazz);
        try {
            clazz.getField(field.getName());
        }
        catch (NotFoundException e) {
            clazz.addField(field);
        }
    }

    protected static void addMethod(String def, CtClass clazz) throws CannotCompileException {
        AbstractWeaver.addMethod(clazz, CtNewMethod.make(def, clazz));
    }

    protected static void addSuperDelegateMethod(String def, CtClass clazz) throws CannotCompileException {
        CtMethod method = null;
        try {
            method = CtNewMethod.make(def, clazz);
        }
        catch (CannotCompileException cannotCompileException) {
            // empty catch block
        }
        if (null != method) {
            AbstractWeaver.addMethod(clazz, method);
        }
    }

    private static void addMethod(CtClass ctClass, CtMethod method) throws CannotCompileException {
        try {
            CtMethod m = ctClass.getMethod(method.getName(), method.getMethodInfo().getDescriptor());
            if (!m.getDeclaringClass().equals(ctClass) && !AbstractWeaver.isFinal(m)) {
                ctClass.addMethod(method);
            }
        }
        catch (NotFoundException e) {
            ctClass.addMethod(method);
        }
    }
}

