/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nudge.dependency.ooa.Type;
import org.nudge.probe.util.Checker;

class Annotations {
    private static final int INITIAL_CAPACITY = 2;
    private final Set<String> annotations = new HashSet<String>(2);
    private final Map<String, Map<String, Object>> annotationsValues = new HashMap<String, Map<String, Object>>(2);

    Annotations() {
    }

    Set<String> getAnnotations() {
        return this.annotations;
    }

    Map<String, Object> getAnnotationValues(String annotation) {
        Map<String, Object> values = this.annotationsValues.get(annotation);
        if (null == values) {
            values = Collections.emptyMap();
        }
        return values;
    }

    void addAnnotation(Type annotation) {
        Checker.checkArgument(null != annotation);
        this.annotations.add(Annotations.getAnnotationName(annotation));
    }

    void addAnnotationValue(Type annotation, String valueName, Object value) {
        Checker.checkArgument(null != annotation);
        Checker.checkArgument(null != valueName);
        String annotationName = Annotations.getAnnotationName(annotation);
        Map<String, Object> values = this.annotationsValues.get(annotationName);
        if (null == values) {
            values = new HashMap<String, Object>();
            this.annotationsValues.put(annotationName, values);
        }
        values.put(valueName, value);
    }

    private static String getAnnotationName(Type annotation) {
        String name = annotation.getClassName();
        Checker.checkState(!(name = name.replace('.', '/')).startsWith("L") && !name.endsWith(";"), "invalid annotation type");
        return name;
    }
}

