/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.nudge.dependency.oaci.IOUtils;
import org.nudge.dependency.ooa.AnnotationVisitor;
import org.nudge.dependency.ooa.ClassReader;
import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.MethodVisitor;
import org.nudge.dependency.ooa.Type;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.Annotations;
import org.nudge.probe.weave.MethodDef;

public class ClassDef {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);
    private static final Map<String, ClassDef> knownClassDefs = new WeakHashMap<String, ClassDef>(10000);
    private static final ClassDef NULL_CACHE_ENTRY = new ClassDef();
    private String name;
    private String superName;
    private final List<String> interfaces = new ArrayList<String>();
    private final Set<String> allSuperNames = new HashSet<String>();
    private final Set<String> allInterfaces = new HashSet<String>();
    private final Annotations annotations = new Annotations();
    private final List<MethodDef> methods = new ArrayList<MethodDef>();
    private final ClassLoader classLoader;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isAnnotation;
    private boolean atLeastJava5;
    private boolean isJdkProxy;

    private ClassDef(byte[] classBytes, ClassLoader cl) {
        this.classLoader = cl;
        try {
            this.readClass(classBytes);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("unable to read class from bytecode, bytecode version = " + ClassDef.readVersion(classBytes), e);
        }
    }

    private ClassDef() {
        this.classLoader = null;
    }

    public static ClassDef fromBytecode(byte[] classBytes, ClassLoader cl) {
        return new ClassDef(classBytes, cl);
    }

    public static ClassDef fromClassLoaderResource(String className, ClassLoader cl) {
        byte[] classBytes;
        String cacheKey;
        ClassDef classDef;
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (null != (classDef = knownClassDefs.get(cacheKey = String.format("%s|%s", cl.hashCode(), className)))) {
            if (NULL_CACHE_ENTRY == classDef) {
                return null;
            }
            return classDef;
        }
        InputStream classStream = cl.getResourceAsStream(className + ".class");
        if (null == classStream) {
            knownClassDefs.put(cacheKey, NULL_CACHE_ENTRY);
            return null;
        }
        try {
            classBytes = IOUtils.toByteArray(classStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(classStream);
        }
        if (!ClassDef.hasJavaMagicNumber(classBytes)) {
            log.warning("invalid bytecode from classloader resource for class : %s", className);
            return null;
        }
        classDef = ClassDef.fromBytecode(classBytes, cl);
        knownClassDefs.put(cacheKey, classDef);
        return classDef;
    }

    private static boolean hasJavaMagicNumber(byte[] classBytes) {
        return classBytes[0] == -54 && classBytes[1] == -2 && classBytes[2] == -70 && classBytes[3] == -66;
    }

    private static short readVersion(byte[] classBytes) {
        return (short)((classBytes[6] & 0xFF) << 8 | classBytes[7] & 0xFF);
    }

    private void readClass(byte[] classBytes) {
        Checker.checkArgument(null != classBytes && classBytes.length > 0);
        ClassReader reader = new ClassReader(classBytes);
        reader.accept(new ClassVisitor(589824){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ClassDef.this.name = name;
                ClassDef.this.superName = superName;
                ClassDef.this.interfaces.addAll(Arrays.asList(interfaces));
                ClassDef.this.isInterface = (access & 0x200) == 512;
                ClassDef.this.isEnum = (access & 0x4000) == 16384;
                ClassDef.this.isAnnotation = (access & 0x2000) == 8192;
                ClassDef.this.atLeastJava5 = version != 196653 && version >= 49;
                ClassDef.this.isJdkProxy = (access & 0x10) == 16 && superName.equals("java/lang/reflect/Proxy");
            }

            @Override
            public AnnotationVisitor visitAnnotation(String annotationName, boolean arg1) {
                final Type annotationType = Type.getType(annotationName);
                ClassDef.this.annotations.addAnnotation(annotationType);
                return new AnnotationVisitor(589824){

                    @Override
                    public void visit(String valueName, Object value) {
                        ClassDef.this.annotations.addAnnotationValue(annotationType, valueName, value);
                    }
                };
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if ((access & 0x1000) > 0) {
                    return null;
                }
                final MethodDef md = new MethodDef(access, name, desc);
                ClassDef.this.methods.add(md);
                return new MethodVisitor(589824){

                    @Override
                    public AnnotationVisitor visitAnnotation(String name, boolean visible) {
                        md.addAnnotation(Type.getType(name));
                        return super.visitAnnotation(name, visible);
                    }
                };
            }
        }, 7);
        this.loadHierarchy();
    }

    public static String getJvmClassName(Class<?> type) {
        int lastSlash;
        String name = type.getCanonicalName().replaceAll("\\.", "/");
        if (type.getEnclosingClass() != null && (lastSlash = name.lastIndexOf(47)) > 0) {
            char[] characters = name.toCharArray();
            characters[lastSlash] = 36;
            name = new String(characters);
        }
        return name;
    }

    public static ClassDef fromClass(Class<?> type) {
        return ClassDef.fromClassLoaderResource(ClassDef.getJvmClassName(type), type.getClassLoader());
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperName() {
        return this.superName;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<String> getAllSuperNames() {
        return this.allSuperNames;
    }

    public Set<String> getAllInterfaces() {
        return this.allInterfaces;
    }

    public Set<String> getAnnotations() {
        return this.annotations.getAnnotations();
    }

    public Map<String, Object> getAnnotationValues(String annotation) {
        return this.annotations.getAnnotationValues(annotation);
    }

    public List<MethodDef> getMethods() {
        return this.methods;
    }

    public boolean isAtLeastJava5() {
        return this.atLeastJava5;
    }

    public boolean isJdkProxy() {
        return this.isJdkProxy;
    }

    public String toString() {
        return "ClassDef [name=" + this.name + ", superName=" + this.superName + ", interfaces=" + this.interfaces + ", annotations=" + this.annotations + ", methods=" + this.methods + "]";
    }

    private void loadHierarchy() {
        Stack<String> stack = new Stack<String>();
        if (null != this.superName && !"java/lang/Object".equals(this.superName)) {
            stack.add(this.superName);
        }
        stack.addAll(this.interfaces);
        while (!stack.isEmpty()) {
            String itemName = (String)stack.pop();
            ClassDef item = ClassDef.fromClassLoaderResource(itemName, this.classLoader);
            if (null == item) {
                log.fine("Superclass could not be loaded: " + itemName, new Object[0]);
                continue;
            }
            if (item.isInterface()) {
                this.allInterfaces.add(item.getName());
                stack.addAll(item.getAllInterfaces());
                continue;
            }
            this.allSuperNames.add(item.getName());
            this.allSuperNames.addAll(item.getAllSuperNames());
            this.allInterfaces.addAll(item.getAllInterfaces());
        }
    }
}

