/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nudge.dependency.ooa.Type;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.Annotations;

public class MethodDef {
    private final int access;
    private final String name;
    private final Annotations annotations;
    private final String signature;
    private final boolean isConstructor;
    private final List<String> parameters;
    private final String returnType;

    public MethodDef(int access, String name, String signature) {
        Checker.checkArgument(null != name);
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.annotations = new Annotations();
        this.isConstructor = "<init>".equals(name);
        Type[] argumentTypes = Type.getArgumentTypes(signature);
        this.parameters = new ArrayList<String>();
        for (Type argumentType : argumentTypes) {
            this.parameters.add(argumentType.getDescriptor());
        }
        this.returnType = Type.getReturnType(signature).getDescriptor();
    }

    void addAnnotation(Type annotation) {
        this.annotations.addAnnotation(annotation);
    }

    void addAnnotationValue(Type annotation, String valueName, Object value) {
        this.annotations.addAnnotationValue(annotation, valueName, value);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAnnotations() {
        return this.annotations.getAnnotations();
    }

    public Map<String, Object> getAnnotationValues(String annotation) {
        return this.annotations.getAnnotationValues(annotation);
    }

    public boolean isPublic() {
        return (this.access & 1) > 0;
    }

    public boolean isProtected() {
        return (this.access & 4) > 0;
    }

    public boolean isPrivate() {
        return (this.access & 2) > 0;
    }

    public boolean isStatic() {
        return (this.access & 8) > 0;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<String> getSignatureParameters() {
        return this.parameters;
    }

    public String getSignatureReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDef methodDef = (MethodDef)o;
        if (this.access != methodDef.access) {
            return false;
        }
        if (!this.name.equals(methodDef.name)) {
            return false;
        }
        if (!this.annotations.equals(methodDef.annotations)) {
            return false;
        }
        return !(this.signature != null ? !this.signature.equals(methodDef.signature) : methodDef.signature != null);
    }

    public String getCacheKey() {
        return this.name + this.getSignature();
    }

    public boolean isPublicInstanceMethod() {
        return this.isPublic() && !this.isStatic() && !this.isConstructor();
    }

    public int hashCode() {
        int result = this.access;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MethodDef [access=" + this.access + ", name=" + this.name + ", annotations=" + this.annotations + ", signature=" + this.signature + "]";
    }
}

