/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.FieldVisitor;
import org.nudge.dependency.ooa.Label;
import org.nudge.dependency.ooa.MethodVisitor;
import org.nudge.dependency.ooa.commons.JSRInlinerAdapter;
import org.nudge.probe.weave.AsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.NudgeMethodVisitor;
import org.nudge.probe.weave.WeaverUtil;

public class NudgeClassVisitor
extends ClassVisitor {
    private static final int SYNTHETIC_STATIC = 4104;
    private final ClassDef classDef;
    private final ClassLoader cl;
    private final String syntheticClassFieldName;
    private final AsmWeaver weaver;
    private int classVersion;
    private boolean byteCodeJava14OrBefore;
    private boolean hasGeneratedGetClassMethod;
    private boolean hasSyntheticClassField;
    private boolean addFields;

    NudgeClassVisitor(ClassLoader cl, ClassDef classDef, ClassVisitor cv, AsmWeaver weaver) {
        super(589824, cv);
        this.classDef = classDef;
        this.syntheticClassFieldName = WeaverUtil.getSyntheticClassTypeFieldName(classDef.getName());
        this.cl = cl;
        this.weaver = weaver;
        this.addFields = true;
    }

    public String toString() {
        return "NudgeClassVisitor{class=='" + this.classDef + "'}";
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classVersion = version;
        switch (this.classVersion) {
            case 46: 
            case 47: 
            case 48: 
            case 196653: {
                this.byteCodeJava14OrBefore = true;
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1008) > 0 && this.syntheticClassFieldName.equals(name)) {
            this.hasSyntheticClassField = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.byteCodeJava14OrBefore && !this.hasSyntheticClassField) {
            FieldVisitor fv = this.visitField(4104, this.syntheticClassFieldName, "Ljava/lang/Class;", null, null);
            fv.visitEnd();
            this.hasSyntheticClassField = true;
        }
        if ((access & 0x1008) > 0 && "class$".equals(name) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(desc)) {
            this.hasGeneratedGetClassMethod = true;
        }
        if (this.addFields) {
            for (int i = 0; i < this.weaver.addClassFieldsSize(); ++i) {
                this.weaver.addClassField(this.classDef, i, this);
            }
            this.addFields = false;
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
        return new NudgeMethodVisitor(this.cl, mv, access, this.classDef, name, desc, this.byteCodeJava14OrBefore, this.weaver);
    }

    @Override
    public void visitEnd() {
        if (this.byteCodeJava14OrBefore && !this.hasGeneratedGetClassMethod) {
            this.injectSyntheticGetClassMethod(this.classVersion);
            this.hasGeneratedGetClassMethod = true;
        }
        super.visitEnd();
    }

    private void injectSyntheticGetClassMethod(int classVersion) {
        int max;
        MethodVisitor mv = super.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/ClassNotFoundException");
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        mv.visitLabel(l1);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitVarInsn(58, 1);
        mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
        mv.visitInsn(89);
        if (48 == classVersion) {
            max = 2;
            mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "()V", false);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/NoClassDefFoundError", "initCause", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", false);
        } else {
            max = 3;
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, 196653 == classVersion ? "java/lang/Throwable" : "java/lang/ClassNotFoundException", "getMessage", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V", false);
        }
        mv.visitInsn(191);
        mv.visitMaxs(max, 2);
        mv.visitEnd();
    }
}

