/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import org.nudge.dependency.ooa.ClassWriter;
import org.nudge.probe.weave.ClassDef;

public class NudgeClassWriter
extends ClassWriter {
    private final ClassLoader readClassLoader;
    private final ClassDef writingClass;

    public NudgeClassWriter(ClassLoader readClassLoader, ClassDef writingClass, int flags) {
        super(flags);
        this.readClassLoader = readClassLoader;
        this.writingClass = writingClass;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Class d;
        Class c;
        if (null != this.writingClass) {
            String superName = this.writingClass.getSuperName();
            String className = this.writingClass.getName();
            if (type1.equals(className)) {
                return this.getCommonSuperClass(superName, type2);
            }
            if (type2.equals(className)) {
                return this.getCommonSuperClass(type1, superName);
            }
        }
        try {
            c = this.getClass(type1);
            d = this.getClass(type2);
        }
        catch (ClassNotFoundException e) {
            return "java/lang/Object";
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to load class %s or %s", type1, type2));
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }

    private Class getClass(String type) throws ClassNotFoundException {
        return Class.forName(type.replace('/', '.'), false, this.readClassLoader);
    }
}

