/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import org.nudge.dependency.ooa.AnnotationVisitor;
import org.nudge.dependency.ooa.Label;
import org.nudge.dependency.ooa.MethodVisitor;
import org.nudge.dependency.ooa.Type;
import org.nudge.dependency.ooa.commons.AdviceAdapter;
import org.nudge.probe.LoggerFactory;
import org.nudge.probe.NudgeLogger;
import org.nudge.probe.ProxyClassLoader;
import org.nudge.probe.events.LogEventBuilder;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.util.Checker;
import org.nudge.probe.weave.AsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;
import org.nudge.probe.weave.WeaverUtil;

public class NudgeMethodVisitor
extends AdviceAdapter {
    private static final Logger log = Logger.getLogger(NudgeMethodVisitor.class.getName());
    private final String methodSignature;
    private final ClassDef classDef;
    private final boolean isStatic;
    private final boolean byteCodeJava14OrBefore;
    private final Type methodReturnType;
    private final Type[] methodArgumentTypes;
    private final MethodDef methodDef;
    private final Label start = this.newLabel();
    private final Label end = this.newLabel();
    private final Label handler = this.newLabel();
    private final ClassLoader cl;
    private final AsmWeaver weaver;
    private boolean matches = false;

    NudgeMethodVisitor(ClassLoader cl, MethodVisitor mv, int access, ClassDef classDef, String methodName, String methodDesc, boolean byteCodeJava14OrBefore, AsmWeaver weaver) {
        super(589824, mv, access, methodName, methodDesc);
        this.cl = cl;
        this.methodDef = new MethodDef(access, methodName, methodDesc);
        this.methodSignature = WeaverUtil.getMethodSignature(access, classDef.getName(), methodName, methodDesc);
        this.classDef = classDef;
        this.isStatic = (access & 8) > 0;
        this.methodReturnType = Type.getReturnType(methodDesc);
        this.methodArgumentTypes = Type.getArgumentTypes(methodDesc);
        this.byteCodeJava14OrBefore = byteCodeJava14OrBefore;
        this.weaver = weaver;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, boolean visible) {
        final Type annotationType = Type.getType(name);
        this.methodDef.addAnnotation(annotationType);
        return new AnnotationVisitor(589824, super.visitAnnotation(name, visible)){

            @Override
            public void visit(String name, Object value) {
                NudgeMethodVisitor.this.methodDef.addAnnotationValue(annotationType, name, value);
                this.av.visit(name, value);
            }
        };
    }

    @Override
    protected void onMethodEnter() {
        this.matches = this.weaver.matches(this.methodDef, this.cl);
        if (!this.matches) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(" %s instrumentation method %s %s %s", this.weaver.getClass().getSimpleName(), this.classDef.getName(), this.methodDef.getName(), this.methodDef.getSignature());
        }
        this.visitLabel(this.start);
        this.injectNudgeLogger(true, -1);
    }

    @Override
    protected void onMethodExit(int opcode) {
        if (!this.matches) {
            return;
        }
        if (opcode != 191) {
            this.injectNudgeLogger(false, opcode);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (!this.matches) {
            super.visitMaxs(maxStack, maxLocals);
            return;
        }
        this.visitLabel(this.end);
        this.visitLabel(this.handler);
        this.injectNudgeLogger(false, 191);
        this.throwException();
        this.visitTryCatchBlock(this.start, this.end, this.handler, "java/lang/Throwable");
        super.visitMaxs(maxStack, maxLocals);
    }

    private void injectNudgeLogger(boolean isEntering, int opcode) {
        boolean isConstructorExit;
        if (opcode > 0) {
            Checker.checkArgument(!isEntering, "opcode should only be used while entering");
        }
        int returnVar = -1;
        boolean isException = !isEntering && opcode == 191;
        boolean isReturnWithoutValue = !isEntering && opcode == 177;
        boolean isReturnValue = !isEntering && !isException && !isReturnWithoutValue;
        boolean bl = isConstructorExit = !isEntering && this.methodDef.isConstructor();
        if (isException || isReturnValue) {
            Type returnVarType = isException ? Type.getType(Throwable.class) : this.methodReturnType;
            returnVar = this.newLocal(returnVarType);
            this.storeLocal(returnVar);
        }
        Type nudgeLoggerType = Type.getType(NudgeLogger.class);
        Type logEventBuilderType = Type.getType(LogEventBuilder.class);
        Type classLoaderType = Type.getType(ClassLoader.class);
        this.visitMethodInsn(184, Type.getInternalName(LoggerFactory.class), "getLogger", Type.getMethodType(nudgeLoggerType, new Type[0]).getDescriptor(), false);
        this.loadClassType(this.classDef.getName());
        this.visitMethodInsn(182, Type.getInternalName(Class.class), "getClassLoader", Type.getMethodType(classLoaderType, new Type[0]).getDescriptor(), false);
        this.visitMethodInsn(185, nudgeLoggerType.getInternalName(), "newEvent", Type.getMethodType(logEventBuilderType, classLoaderType).getDescriptor(), true);
        this.visitLdcInsn(this.weaver.getType());
        this.visitBuilderMethod("type", String.class);
        if (!this.isStatic && !this.methodDef.isConstructor()) {
            this.visitVarInsn(25, 0);
            this.visitBuilderMethod("methodTarget", Object.class);
        } else {
            this.loadClassType(this.classDef.getName());
            this.visitBuilderMethod("methodTargetType", Class.class);
        }
        this.visitLdcInsn(this.methodSignature);
        this.visitBuilderMethod("method", String.class);
        String handlerClass = this.weaver.getHandlerClass();
        Checker.checkState(null != handlerClass && handlerClass.length() > 0, "handler class should not be empty or null");
        ProxyClassLoader.addClass(handlerClass);
        this.visitLdcInsn(handlerClass);
        this.visitBuilderMethod("handler", String.class);
        int varIndex = this.isStatic ? 0 : 1;
        for (Type argumentType : this.methodArgumentTypes) {
            this.visitVarInsn(argumentType.getOpcode(21), varIndex);
            varIndex += argumentType.getSize();
            this.autoboxingIfRequired(argumentType);
            this.visitBuilderMethod("methodParam", Object.class);
        }
        if (isException) {
            this.loadLocal(returnVar);
            this.visitBuilderMethod("thrownException", Throwable.class);
        } else if (isReturnValue) {
            this.loadLocal(returnVar);
            this.autoboxingIfRequired(this.methodReturnType);
            this.visitBuilderMethod("returnValue", Object.class);
        } else if (isConstructorExit) {
            this.visitVarInsn(25, 0);
            this.visitBuilderMethod("returnValue", Object.class);
        }
        for (int i = 0; i < this.weaver.contextFieldsSize(); ++i) {
            this.weaver.contextFieldLoadValue(this.classDef, this.methodDef, i, this, this.cl);
            this.visitBuilderMethod("methodContext", Object.class);
        }
        this.visitMethodInsn(185, logEventBuilderType.getInternalName(), isEntering ? "entering" : "exiting", Type.getMethodType(Type.VOID_TYPE, new Type[0]).getDescriptor(), true);
        if (isReturnValue || isException) {
            this.loadLocal(returnVar);
        }
    }

    private void loadClassType(String className) {
        if (!this.byteCodeJava14OrBefore) {
            this.visitLdcInsn(Type.getObjectType(className));
            return;
        }
        String classTypeFieldName = WeaverUtil.getSyntheticClassTypeFieldName(className);
        this.visitFieldInsn(178, className, classTypeFieldName, "Ljava/lang/Class;");
        Label l0 = new Label();
        this.visitJumpInsn(199, l0);
        this.visitLdcInsn(className.replace('/', '.'));
        this.visitMethodInsn(184, className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        this.visitInsn(89);
        this.visitFieldInsn(179, className, classTypeFieldName, "Ljava/lang/Class;");
        Label l1 = new Label();
        this.visitJumpInsn(167, l1);
        this.visitLabel(l0);
        this.visitFieldInsn(178, className, classTypeFieldName, "Ljava/lang/Class;");
        this.visitLabel(l1);
    }

    private void autoboxingIfRequired(Type argType) {
        Class autoboxingType = null;
        switch (argType.getSort()) {
            case 1: {
                autoboxingType = Boolean.class;
                break;
            }
            case 2: {
                autoboxingType = Character.class;
                break;
            }
            case 3: {
                autoboxingType = Byte.class;
                break;
            }
            case 4: {
                autoboxingType = Short.class;
                break;
            }
            case 5: {
                autoboxingType = Integer.class;
                break;
            }
            case 6: {
                autoboxingType = Float.class;
                break;
            }
            case 7: {
                autoboxingType = Long.class;
                break;
            }
            case 8: {
                autoboxingType = Double.class;
            }
        }
        if (null != autoboxingType) {
            Type boxingType = Type.getType(autoboxingType);
            this.visitMethodInsn(184, boxingType.getInternalName(), "valueOf", Type.getMethodType(boxingType, argType).getDescriptor(), false);
        }
    }

    private void visitBuilderMethod(String methodName, Class<?> argumentType) {
        Type logEventBuilderType = Type.getType(LogEventBuilder.class);
        this.visitMethodInsn(185, logEventBuilderType.getInternalName(), methodName, Type.getMethodType(logEventBuilderType, Type.getType(argumentType)).getDescriptor(), true);
    }

    public String toString() {
        return "NudgeMethodVisitor{class='" + this.classDef + '\'' + ", methodSignature='" + this.methodSignature + '\'' + '}';
    }
}

