/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.OLD;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.ClassPool;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.Modifier;
import org.nudge.javassist.NotFoundException;
import org.nudge.javassist.bytecode.MethodInfo;
import org.nudge.probe.Configuration;
import org.nudge.probe.Trace;
import org.nudge.probe.collector.Collector;
import org.nudge.probe.log.Level;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.OLD.AbstractHandler;
import org.nudge.probe.weave.cache.CacheHandler;
import org.nudge.probe.weave.cache.XMemcachedHandler;
import org.nudge.probe.weave.play.PlayControllerHandler;
import org.nudge.probe.weave.search.SearchEngineLuceneHandler;

@Deprecated
public final class Weaver {
    private static final Logger log = Logger.getLogger("org.nudge");
    private long startTime;
    private ClassLoader loader;
    private ProtectionDomain domain;
    private CtClass cc;
    private Configuration config;
    private Collector collector;
    private LinkedList<AbstractHandler> handlers = new LinkedList();
    private LinkedList<String> instrumentedMethods = new LinkedList();
    private LinkedList<String> instrumentedClasses = new LinkedList();
    private LinkedList<String> classesProcessed = new LinkedList();

    public static byte[] transform(ClassLoader loader, ProtectionDomain domain, CtClass cc, Configuration config, Collector collector) {
        if (cc == null) {
            return null;
        }
        if (cc.isFrozen()) {
            cc.defrost();
        }
        try {
            Weaver weaver = new Weaver(loader, domain, cc, config, collector);
            weaver.process(cc);
            if (weaver.isClassModified()) {
                return weaver.toBytecode();
            }
        }
        catch (CannotCompileException e) {
            log.severe("failed to instrument " + cc.getName() + " - CannotCompileException : " + e.getMessage(), new Object[0]);
            log.severe(e, e.getMessage(), new Object[0]);
        }
        catch (NotFoundException e) {
            log.fine("failed to instrument " + cc.getName() + " - NotFoundException : " + e.getMessage(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.severe("failed to instrument " + cc.getName() + " - ClassNotFoundException : " + e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            log.severe("failed to instrument " + cc.getName() + " - " + e.getClass() + " : " + e.getMessage(), new Object[0]);
        }
        return null;
    }

    private Weaver(ClassLoader loader, ProtectionDomain domain, CtClass cc, Configuration config, Collector collector) {
        this.loader = loader;
        this.domain = domain;
        this.cc = cc;
        this.config = config;
        this.collector = collector;
        this.startTime = System.currentTimeMillis();
        this.handlers.addLast(new PlayControllerHandler(this, loader));
        this.handlers.addLast(new CacheHandler());
        this.handlers.addLast(new XMemcachedHandler());
        this.handlers.addLast(new SearchEngineLuceneHandler());
    }

    public void increaseThreshold(long time) {
        this.startTime += time;
    }

    private void process(CtClass clazz) throws Exception {
        CtClass[] interfaces;
        CtClass superclass;
        if ("java.lang.Object".equals(clazz.getName()) || this.classesProcessed.contains(clazz.getName())) {
            return;
        }
        this.classesProcessed.add(clazz.getName());
        if (log.isLoggable(Level.FINE)) {
            if (!this.cc.getName().equals(clazz.getName())) {
                log.fine("hierarchie de " + this.cc.getName() + " : " + clazz.getName(), new Object[0]);
            } else {
                log.fine("instrumentation de " + this.cc.getName(), new Object[0]);
            }
        }
        if (clazz == this.cc) {
            LinkedList<AbstractHandler> discard = new LinkedList<AbstractHandler>();
            for (AbstractHandler abstractHandler : this.handlers) {
                if (!abstractHandler.match(clazz)) continue;
                abstractHandler.instrument(this.cc, null, this.instrumentedMethods);
                this.instrumentedClasses.addLast(clazz.getName());
                discard.add(abstractHandler);
            }
            if (discard.size() > 0) {
                this.handlers.removeAll(discard);
            }
            if (this.config.isRumActivated()) {
                // empty if block
            }
        }
        if ((superclass = clazz.getSuperclass()) != null && !superclass.getName().equals("java.lang.Object")) {
            LinkedList<AbstractHandler> discard = new LinkedList<AbstractHandler>();
            for (AbstractHandler handler : this.handlers) {
                if (!handler.match(superclass)) continue;
                if (handler.useFilter()) {
                    handler.instrument(this.cc, superclass, this.instrumentedMethods);
                } else {
                    handler.instrument(this.cc, null, this.instrumentedMethods);
                }
                this.instrumentedClasses.addLast(superclass.getName());
                discard.add(handler);
            }
            if (discard.size() > 0) {
                this.handlers.removeAll(discard);
            }
            this.process(superclass);
        }
        for (CtClass intrfc : interfaces = clazz.getInterfaces()) {
            LinkedList<AbstractHandler> discard = new LinkedList<AbstractHandler>();
            for (AbstractHandler handler : this.handlers) {
                if (!handler.match(intrfc)) continue;
                handler.instrument(this.cc, intrfc, this.instrumentedMethods);
                this.instrumentedClasses.addLast(intrfc.getName());
                discard.add(handler);
            }
            if (discard.size() > 0) {
                this.handlers.removeAll(discard);
            }
            this.process(intrfc);
        }
        if (this.cc.hasAnnotation(Trace.class)) {
            for (CtMethod method : clazz.getMethods()) {
                if (!this.instrument(method, null, true)) continue;
                this.instrumentedMethods.addLast(method.getLongName());
            }
            this.instrumentedClasses.addLast("@Trace");
        } else {
            boolean bl;
            boolean bl2 = false;
            for (CtMethod method : clazz.getMethods()) {
                boolean logSql;
                String name;
                if (!method.hasAnnotation(Trace.class) || !this.instrument(method, name = ((Trace)method.getAnnotation(Trace.class)).value(), logSql = true)) continue;
                this.instrumentedMethods.addLast(method.getLongName());
                bl = true;
            }
            if (bl) {
                this.instrumentedClasses.addLast("@Trace");
            }
        }
    }

    private boolean isClassModified() {
        return this.instrumentedMethods.size() != 0;
    }

    private byte[] toBytecode() throws IOException, CannotCompileException {
        if (log.isLoggable(Level.INFO) && this.isClassModified()) {
            StringBuffer buf = new StringBuffer();
            buf.append("CLASS INSTRUMENTED : ");
            buf.append(this.cc.getName());
            buf.append(" ");
            buf.append(this.instrumentedClasses.toString());
            buf.append(" - ");
            buf.append(System.currentTimeMillis() - this.startTime);
            buf.append("ms");
            log.info(buf.toString(), new Object[0]);
            if (log.isLoggable(Level.FINE)) {
                for (String methodName : this.instrumentedMethods) {
                    log.fine("instrument method : " + methodName, new Object[0]);
                }
            }
        }
        return this.cc.toBytecode();
    }

    private boolean instrument(CtMethod method, String alernateName, boolean traceSql) throws CannotCompileException, NotFoundException {
        return this.instrument(method, alernateName, traceSql, false);
    }

    private boolean instrument(CtMethod method, String alernateName, boolean traceSql, boolean isRmi) throws CannotCompileException, NotFoundException {
        CtClass[] exceptions;
        if (!method.getDeclaringClass().equals(this.cc)) {
            return false;
        }
        MethodInfo methodInfo = method.getMethodInfo();
        if (!methodInfo.isMethod() || Modifier.isNative(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) {
            return false;
        }
        if (this.instrumentedMethods.contains(method.getLongName())) {
            return false;
        }
        String code = method.getLongName();
        String alias = alernateName == null || alernateName.equals("") ? method.getLongName() : alernateName;
        StringBuffer buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger nudge = org.nudge.probe.LoggerFactory.getLogger(); ");
        if (isRmi) {
            buf.append("  nudge.entering(org.nudge.probe.EventType.Rmi_Remote,\"" + code + "\",\"" + alias + "\"); ");
        } else {
            buf.append("  nudge.entering(org.nudge.probe.EventType.AOP,\"" + code + "\",\"" + alias + "\"); ");
        }
        if (!traceSql) {
            buf.append("  nudge.stopSqlLog(); ");
        }
        buf.append("} ");
        method.insertBefore(buf.toString());
        for (CtClass exception : exceptions = method.getExceptionTypes()) {
            buf = new StringBuffer(1000);
            buf.append("{ ");
            buf.append("   org.nudge.probe.NudgeLogger nudge = org.nudge.probe.LoggerFactory.getLogger(); ");
            buf.append("   nudge.log($e); ");
            buf.append("   throw $e; ");
            buf.append("} ");
            method.addCatch(buf.toString(), exception);
        }
        buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger nudge = org.nudge.probe.LoggerFactory.getLogger(); ");
        if (!traceSql) {
            buf.append("  nudge.startSqlLog(); ");
        }
        if (isRmi) {
            buf.append("  nudge.exiting(org.nudge.probe.EventType.Rmi_Remote,\"" + code + "\"); ");
        } else {
            buf.append("  nudge.exiting(org.nudge.probe.EventType.AOP,\"" + code + "\"); ");
        }
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
        return true;
    }

    private void loadClasses() throws Throwable {
        if (this.loader == null) {
            return;
        }
        ClassLoader classLoader = this.loader;
        ClassPool cp = ClassPool.getDefault();
        this.loadClass("org.nudge.probe.NudgeLogger", classLoader, cp);
        this.loadClass("org.nudge.probe.NudgeLoggerImpl", classLoader, cp);
        try {
            Class.forName("org.nudge.probe.LoggerFactory", false, classLoader);
        }
        catch (Exception e) {
            try {
                CtClass factory = cp.get("org.nudge.probe.LoggerFactory");
                Class clazz = factory.toClass(classLoader, this.domain);
                ClassLoader cl = clazz.getClassLoader();
                Method m = clazz.getDeclaredMethod("setCollector", cl.loadClass("org.nudge.probe.Collector"));
                m.invoke(null, this.collector);
                m = clazz.getDeclaredMethod("setConfiguration", cl.loadClass("org.nudge.probe.Configuration"));
                m.invoke(null, this.config);
            }
            catch (Throwable t) {
                log.info("        loading LoggerFactory - exception : " + t, new Object[0]);
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable = t;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    for (StackTraceElement ste : throwable.getStackTrace()) {
                        log.info("           " + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getLineNumber() + ")", new Object[0]);
                    }
                }
                throw t;
            }
        }
    }

    private void loadClass(String className, ClassLoader classLoader, ClassPool cp) throws Throwable {
        try {
            Class.forName(className, false, classLoader);
        }
        catch (Exception e) {
            try {
                CtClass logger = cp.get(className);
                Class clazz = logger.toClass(classLoader, this.domain);
                ClassLoader cl = clazz.getClassLoader();
                log.fine("        " + className + " - classloader : " + cl.getClass().getName() + " " + cl.hashCode(), new Object[0]);
            }
            catch (Throwable t) {
                log.info("        NudgeLogger - exception : " + t.getMessage(), new Object[0]);
                if (log.isLoggable(Level.FINE)) {
                    for (StackTraceElement ste : t.getStackTrace()) {
                        log.fine("        " + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getLineNumber() + ")", new Object[0]);
                    }
                }
                throw t;
            }
        }
    }
}

