/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave;

import org.nudge.dependency.ooa.Type;
import org.nudge.dependency.ooa.signature.SignatureReader;
import org.nudge.dependency.ooa.util.TraceSignatureVisitor;

class WeaverUtil {
    static final String LEGACY_CLASS = "class$";
    static final String LEGACY_CLASS_METHOD_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Class;";

    WeaverUtil() {
    }

    static String getSyntheticClassTypeFieldName(String fullClassName) {
        return LEGACY_CLASS + fullClassName.replace('/', '$');
    }

    static String getMethodSignature(int access, String className, String name, String desc) {
        SignatureReader sr = new SignatureReader(desc);
        TraceSignatureVisitor sv = new TraceSignatureVisitor(access);
        sr.accept(sv);
        StringBuilder sb = new StringBuilder(className.replace('/', '.'));
        sb.append(".").append(name).append("(");
        Type[] argumentTypes = Type.getArgumentTypes(desc);
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(argumentTypes[i].getClassName());
        }
        sb.append(")");
        return sb.toString();
    }
}

