/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.aop;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.nudge.probe.util.Checker;

public class AopPoincut {
    private final Visibility visibility;
    private final String className;
    private final Pattern classRegex;
    private final String methodName;
    private final Pattern methodRegex;
    private final String type;
    private final String handler;

    public AopPoincut(String pattern) {
        String[] pointcut = pattern.trim().split(" ");
        if (pointcut.length != 3 && pointcut.length != 5) {
            throw new IllegalArgumentException("pattern is invalid (" + pattern + ")");
        }
        String access = pointcut[0].trim();
        this.visibility = Visibility.fromKeyword(access);
        Checker.checkArgument(null != this.visibility, "invalid visibility " + access);
        this.className = pointcut[1].trim();
        String regex = this.className.replace(".", "\\.").replace("*", ".*");
        this.classRegex = Pattern.compile(regex);
        this.methodName = pointcut[2].trim();
        this.methodRegex = Pattern.compile(this.methodName.replace("*", ".*"));
        this.type = pointcut.length == 5 ? pointcut[3] : "AOP";
        this.handler = pointcut.length == 5 ? AopPoincut.parseHandler(pointcut[4]) : "org.nudge.probe.events.BaseEventHandler";
    }

    public static List<AopPoincut> parseList(List<String> list) {
        ArrayList<AopPoincut> result = new ArrayList<AopPoincut>();
        for (String aop : list) {
            String value = aop.trim().replaceAll("\\.", "/");
            if (value.length() <= 0) continue;
            result.add(new AopPoincut(value));
        }
        return result;
    }

    private static String parseHandler(String s) {
        if ("tx".equals(s)) {
            return "org.nudge.probe.events.BaseEventHandler";
        }
        if ("layer".equals(s)) {
            return "org.nudge.probe.events.OutputOnlyHandler";
        }
        if ("all".equals(s)) {
            return "org.nudge.probe.weave.aop.AopHandler";
        }
        throw new IllegalArgumentException("invalid value, expected tx|layer|all, got " + s);
    }

    public String getType() {
        return this.type;
    }

    public String getHandler() {
        return this.handler;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.ANY || this.visibility == Visibility.PUBLIC;
    }

    public boolean isProtected() {
        return this.visibility == Visibility.ANY || this.visibility == Visibility.PROTECTED;
    }

    public boolean isPrivate() {
        return this.visibility == Visibility.ANY || this.visibility == Visibility.PRIVATE;
    }

    public String getClassName() {
        return this.className;
    }

    public Pattern getClassRegex() {
        return this.classRegex;
    }

    public boolean classMatches(String className) {
        return this.className.equals(className) || this.classRegex.matcher(className).matches();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Pattern getMethodRegex() {
        return this.methodRegex;
    }

    public String toString() {
        return "AopPoincut [visibility=" + (Object)((Object)this.visibility) + ", className=" + this.className + ", classRegex=" + this.classRegex + ", methodName=" + this.methodName + ", methodRegex=" + this.methodRegex + "]";
    }

    public static enum Visibility {
        ANY("*"),
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private");

        private final String keyword;

        private Visibility(String keyword) {
            this.keyword = keyword;
        }

        public static Visibility fromKeyword(String keyword) {
            for (Visibility visibility : Visibility.values()) {
                if (!visibility.keyword.equals(keyword)) continue;
                return visibility;
            }
            return null;
        }
    }
}

