/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nudge.probe.CustomHandler;
import org.nudge.probe.MethodCall;
import org.nudge.probe.Scope;
import org.nudge.probe.Trace;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.EventHandler;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.util.Checker;

public class NudgeTraceAnnotationHandler
implements EventHandler {
    @Override
    public void onEntering(EventContext context) {
        Trace trace = context.getMethodAnnotation(Trace.class);
        Checker.checkState(null != trace);
        Checker.checkState(null != trace.scope());
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (trace.scope() == Scope.TRANSACTION) {
            if (!ip.isInTx()) {
                ip.makeDefineTx();
            }
        } else if (trace.scope() == Scope.LAYER) {
            if (ip.isDefineTx()) {
                ip.makeNotDefineTx();
            }
            if (ip.isInTx() && !ip.isBeyondOutput() && !ip.isDefineOutput()) {
                ip.makeDefineOutput();
            }
        } else {
            throw new IllegalStateException("unsupported @Trace annotation scope " + (Object)((Object)trace.scope()));
        }
    }

    @Override
    public void onExiting(EventContext context) {
        List<ExtendedCode> extCodes;
        Trace trace = context.getMethodAnnotation(Trace.class);
        Checker.checkState(null != trace);
        Checker.checkState(null != trace.scope());
        String type = trace.type();
        String code = trace.value();
        Map<String, String> extendedCodes = null;
        if (null != trace.handler()) {
            Checker.checkState(null == trace.handler().getEnclosingClass(), "custom handler must be declared in a public class");
            CustomHandler handler = this.getCustomHandler(context, trace.handler());
            type = handler.getType();
            code = handler.getCode();
            extendedCodes = handler.getExtendedCodes();
        }
        if (null == type || type.length() == 0) {
            type = trace.type();
        }
        if (null == type || type.length() == 0) {
            type = "@Trace";
        }
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (null == code || code.length() == 0) {
            code = ip.getMethod();
        }
        if (null == extendedCodes) {
            extCodes = Collections.emptyList();
        } else {
            extCodes = new ArrayList(extendedCodes.size());
            for (Map.Entry<String, String> entry : extendedCodes.entrySet()) {
                extCodes.add(ExtendedCode.extCode(entry.getKey(), entry.getValue()));
            }
        }
        ProtocolFacade protocol = context.getProtocol();
        Throwable exception = context.getThrownException();
        if (trace.scope() == Scope.TRANSACTION) {
            protocol.setType(type).setCode(code).setMethodname(ip.getMethod()).setException(exception).setUpstreamToken(ip.getUpstreamToken());
            for (ExtendedCode ec : extCodes) {
                protocol.addExtendedCode(ec);
            }
        } else if (trace.scope() == Scope.LAYER) {
            protocol.createOrUpdateLayerItem(ip.getStartTime(), type, code, extCodes.toArray(new ExtendedCode[extCodes.size()])).addCall(context);
        }
    }

    private CustomHandler getCustomHandler(MethodCall methodCall, Class<? extends CustomHandler> handlerClass) {
        CustomHandler handler;
        try {
            Constructor<? extends CustomHandler> constructor = handlerClass.getConstructor(MethodCall.class);
            handler = constructor.newInstance(methodCall);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        return handler;
    }
}

