/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.cache;

import java.lang.reflect.Modifier;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.OLD.DefaultHandler;

public class CacheHandler
extends DefaultHandler {
    @Override
    public boolean match(String className) {
        return "net.sf.jsr107cache.Cache".equals(className) || "net.sf.ehcache.Ehcache".equals(className) || "org.infinispan.Cache".equals(className);
    }

    @Override
    public void beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
    }

    @Override
    public boolean instrument(CtMethod m) throws CannotCompileException, NotFoundException {
        String method;
        if (Modifier.isPublic(m.getModifiers()) && ((method = m.getName()).startsWith("put") || method.startsWith("load") || method.startsWith("remove") || "getWithLoader".equals(method) || "getQuiet".equals(method) || "get".equals(method) || method.startsWith("getAll"))) {
            this.build(m);
            return true;
        }
        return false;
    }

    private void build(CtMethod method) throws CannotCompileException, NotFoundException {
        StringBuffer buf = new StringBuffer(500);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.enteringCategory( \"CACHE\" ); ");
        buf.append("} ");
        method.insertBefore(buf.toString());
        this.addCatch(method);
        buf = new StringBuffer(500);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.exitingCategory( \"CACHE\" ); ");
        buf.append("} ");
        method.insertAfter(buf.toString(), true);
    }
}

