/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.ejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;

public class Ejb3Handler
extends BaseEventHandler {
    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        InstrumentationPoint previous = ip.getPrevious();
        Object methodTarget = context.getMethodTarget(Object.class);
        if (methodTarget instanceof InvocationHandler) {
            if (ip.getState().belowTx()) {
                ip.makeDefineOutput();
            }
            return;
        }
        boolean ejbJaxWs = false;
        if (null != previous && previous.getMethod().equals(ip.getMethod()) && previous.getType().equals("JAX-WS")) {
            previous = previous.getPrevious();
            ejbJaxWs = true;
        }
        if (null == previous) {
            return;
        }
        String previousType = previous.getType();
        if (previousType.equals("RMI")) {
            if (previous.isDefineTx()) {
                if (ip.isBeyondOutput()) {
                    ip.makeDefineOutput();
                }
                ip.makeDefineTx();
                return;
            }
        } else if (previousType.equals("Servlet") && ejbJaxWs) {
            return;
        }
        if (ip.getState().belowTx()) {
            ip.makeDefineOutput(true);
        }
    }

    @Override
    protected void exitAsOutput(EventContext context) {
        Object methodTarget = context.getMethodTarget(Object.class);
        if (methodTarget instanceof InvocationHandler) {
            Method method = context.getMethodParam(1, Method.class);
            InstrumentationPoint ip = context.getInstrumentationPoint();
            context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "EJB", Ejb3Handler.getMethodSignature(method), new ExtendedCode[0]).addCall(context);
        } else {
            super.exitAsOutput(context);
        }
    }

    private static String getMethodSignature(Method method) {
        StringBuilder code = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(",");
            }
            code.append(paramTypes[i].getName());
        }
        code.append(")");
        return code.toString();
    }
}

