/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.ejb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class Ejb3Weaver
extends AbstractAsmWeaver {
    private static final Set<String> ANNOTATIONS = new HashSet<String>(Arrays.asList("javax/ejb/Stateless", "javax/ejb/Stateful", "jakarta/ejb/Stateless", "jakarta/ejb/Stateful"));
    public static final Set<String> EJB_INVOCATION_HANDLERS = new HashSet<String>(Arrays.asList("org/ow2/easybeans/proxy/client/ClientRPCInvocationHandler", "org/jboss/ejb/client/EJBInvocationHandler"));
    private final Set<String> ejbMethods = new HashSet<String>();
    private boolean invocationHandler = false;

    public Ejb3Weaver() {
        super("EJB", "org.nudge.probe.weave.ejb.Ejb3Handler");
    }

    @Override
    public boolean matches(ClassDef type, ClassLoader cl) {
        for (String name : type.getAnnotations()) {
            if (!ANNOTATIONS.contains(name)) continue;
            return true;
        }
        for (String name : type.getAllInterfaces()) {
            ClassDef classDef = ClassDef.fromClassLoaderResource(name, cl);
            if (null != classDef && (classDef.getAnnotations().contains("javax/ejb/Remote") || classDef.getAnnotations().contains("jakarta/ejb/Remote"))) {
                return true;
            }
            if (!name.equals("java/lang/reflect/InvocationHandler") || !EJB_INVOCATION_HANDLERS.contains(type.getName())) continue;
            this.invocationHandler = true;
            return true;
        }
        return false;
    }

    @Override
    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
        if (this.invocationHandler) {
            return;
        }
        ClassDef originalClass = ClassDef.fromClassLoaderResource(className, cl);
        if (null != originalClass) {
            for (String i : originalClass.getAllInterfaces()) {
                ClassDef interfaceDef = ClassDef.fromClassLoaderResource(i, cl);
                if (null == interfaceDef) continue;
                for (MethodDef method : interfaceDef.getMethods()) {
                    this.ejbMethods.add(method.getCacheKey());
                }
            }
        }
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        if (this.invocationHandler) {
            return method.getName().equals("invoke") && method.getSignature().equals("(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        return method.isPublicInstanceMethod() && (this.ejbMethods.isEmpty() || this.ejbMethods.contains(method.getCacheKey()));
    }
}

