/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.gwt;

import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class GwtRpcWeaver
extends AbstractAsmWeaver {
    private static final String REMOTE_SERVLET = "com/google/gwt/user/server/rpc/RemoteServiceServlet";
    private static final String REMOTE_SERVICE_ANNOTATION = "com/google/gwt/user/client/rpc/RemoteServiceRelativePath";
    private static final String REMOTE_SERVICE = "com/google/gwt/user/client/rpc/RemoteService";
    private Set<String> gwtMethods = new HashSet<String>();

    public GwtRpcWeaver() {
        super("GWT", "org.nudge.probe.weave.gwt.GwtRpcHandler");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        if (!def.getAllSuperNames().contains(REMOTE_SERVLET)) {
            return false;
        }
        for (String i : def.getAllInterfaces()) {
            ClassDef interfaceDef = ClassDef.fromClassLoaderResource(i, cl);
            if (!GwtRpcWeaver.interfaceMatch(interfaceDef)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void beforeInstrument(byte[] classBytes, String className, ClassLoader cl) {
        ClassDef classDef = ClassDef.fromBytecode(classBytes, cl);
        for (String i : classDef.getAllInterfaces()) {
            ClassDef interfaceDef = ClassDef.fromClassLoaderResource(i, cl);
            if (!GwtRpcWeaver.interfaceMatch(interfaceDef)) continue;
            for (MethodDef method : interfaceDef.getMethods()) {
                this.gwtMethods.add(method.getCacheKey());
            }
        }
    }

    private static boolean interfaceMatch(ClassDef interfaceDef) {
        return null != interfaceDef && interfaceDef.getAllInterfaces().contains(REMOTE_SERVICE) && interfaceDef.getAnnotations().contains(REMOTE_SERVICE_ANNOTATION);
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return method.isPublicInstanceMethod() && (this.gwtMethods.isEmpty() || this.gwtMethods.contains(method.getCacheKey()));
    }
}

