/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.http;

import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;

public abstract class AbstractHttpClientHandler
extends OutputOnlyHandler {
    @Override
    public void onEntering(EventContext context) {
        String token;
        super.onEntering(context);
        InstrumentationPoint ip = context.getInstrumentationPoint();
        HttpRequestContextAdapter httpRequest = this.getHttpRequest(context);
        if ((ip.isDefineOutput() || ip.isBeyondOutput()) && null == (token = httpRequest.getHeader("NUDGE_TOKEN"))) {
            if (ip.isDefineOutput()) {
                ip.makeDefineOutput(true);
            }
            if (null != (token = ip.getDownstreamToken())) {
                httpRequest.setHeader("NUDGE_TOKEN", token);
            }
        }
    }

    @Override
    protected void exitAsOutput(EventContext context) {
        HttpRequestContextAdapter httpRequest = this.getHttpRequest(context);
        if (httpRequest.skip()) {
            return;
        }
        String method = httpRequest.getMethod();
        String uri = httpRequest.getUri();
        int statusCode = httpRequest.getResponseStatusCode();
        InstrumentationPoint ip = context.getInstrumentationPoint();
        if (null == uri || null == method) {
            super.exitAsOutput(context);
        } else {
            context.getProtocol().createOrUpdateLayerItem(context.getInstrumentationPoint().getStartTime(), "HTTP", uri, ExtendedCode.extCode("http.method", method), ExtendedCode.extCode("http.status", statusCode > 0 ? Integer.toString(statusCode) : null)).addCall(context);
        }
    }

    protected abstract HttpRequestContextAdapter getHttpRequest(EventContext var1);

    protected static interface HttpRequestContextAdapter {
        public boolean skip();

        public String getMethod();

        public String getUri();

        public int getResponseStatusCode();

        public String getHeader(String var1);

        public void setHeader(String var1, String var2);
    }
}

