/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jakartars;

import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.nudge.probe.events.BaseEventHandler;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.ProtocolFacade;
import org.nudge.probe.weave.jakartars.MatchType;

public class JakartaRsResourceHandler
extends BaseEventHandler {
    private static final ThreadLocal<List<String>> resourceChain = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    @Override
    public void onEntering(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        InstrumentationPoint previous = ip.getPrevious();
        if (null != previous && previous.getType().equals("Servlet") && !ip.isDefineTx()) {
            ip.makeDefineTx();
        }
        MatchType matchType = context.getMethodContext(3, MatchType.class);
        if (ip.isDefineTx()) {
            if (MatchType.SUB_RESOURCE == matchType) {
                ip.makeTxSpanStartOrContinue();
            } else if (MatchType.RESOURCE_CONTENT == matchType) {
                ip.makeTxSpanEnd();
            }
        }
    }

    @Override
    protected void exitAsTransaction(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        ProtocolFacade protocol = context.getProtocol();
        String code = ip.getMethod();
        UriInfo uriInfo = context.getMethodContext(2, UriInfo.class);
        String resourcePath = JakartaRsResourceHandler.cleanPath(context.getMethodContext(0, String.class));
        String methodPath = JakartaRsResourceHandler.cleanPath(context.getMethodContext(1, String.class));
        String httpMethod = this.getHttpMethod(context);
        protocol.addExtendedCode(ExtendedCode.extCode("http.method", httpMethod));
        MatchType matchType = context.getMethodContext(3, MatchType.class);
        List<String> chain = resourceChain.get();
        if (chain.isEmpty() && null != uriInfo) {
            JakartaRsResourceHandler.addToChain(JakartaRsResourceHandler.getRequestPrefix(uriInfo), chain);
        }
        JakartaRsResourceHandler.addToChain(resourcePath, chain);
        JakartaRsResourceHandler.addToChain(methodPath, chain);
        if (MatchType.RESOURCE_CONTENT == matchType) {
            StringBuilder sb = new StringBuilder();
            if (null != httpMethod) {
                sb.append(httpMethod).append(" ");
            }
            if (chain.isEmpty()) {
                sb.append(ip.getMethod());
            } else {
                for (String chainItem : chain) {
                    sb.append("/");
                    sb.append(chainItem);
                }
            }
            protocol.setType(ip.getType()).setMethodname(ip.getMethod()).setCode(sb.toString()).setException(context.getThrownException()).setUpstreamToken(ip.getUpstreamToken());
            resourceChain.remove();
        }
    }

    private static void addToChain(String item, List<String> chain) {
        if (null != item && item.length() > 0) {
            chain.add(item);
        }
    }

    private String getHttpMethod(EventContext context) {
        for (Annotation a : context.getMethodAnnotations()) {
            for (Annotation aa : a.annotationType().getAnnotations()) {
                if (!(aa instanceof HttpMethod)) continue;
                return ((HttpMethod)aa).value();
            }
        }
        return null;
    }

    private static String cleanPath(String s) {
        int start;
        if (null == s) {
            return null;
        }
        int end = s.length() - 1;
        for (start = 0; start < end && s.charAt(start) == '/'; ++start) {
        }
        while (start < end && s.charAt(end) == '/') {
            --end;
        }
        return s.substring(start, end + 1);
    }

    private static String getRequestPrefix(UriInfo uriInfo) {
        String path;
        if (null == uriInfo) {
            return null;
        }
        String requestUri = uriInfo.getRequestUri().getPath();
        int index = requestUri.indexOf(path = uriInfo.getPath());
        if (index <= 0) {
            return null;
        }
        return JakartaRsResourceHandler.cleanPath(requestUri.substring(0, index));
    }
}

