/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jaxrs;

import java.util.HashMap;
import java.util.Map;
import org.nudge.dependency.ooa.AnnotationVisitor;
import org.nudge.dependency.ooa.ClassVisitor;
import org.nudge.dependency.ooa.FieldVisitor;
import org.nudge.dependency.ooa.Type;
import org.nudge.dependency.ooa.commons.GeneratorAdapter;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;
import org.nudge.probe.weave.jaxrs.MatchType;

public class JaxRsResourceWeaver
extends AbstractAsmWeaver {
    private static final String ANNOTATION_PATH = "javax/ws/rs/Path";
    private static final String ANNOTATION_HTTP_METHOD = "javax/ws/rs/HttpMethod";
    private static final String NUDGE_URIINFO = "nudge#uriinfo";
    private static final Type URIINFO = Type.getObjectType("javax/ws/rs/core/UriInfo");
    private static final Type CONTEXT_ANNOTATION = Type.getObjectType("javax/ws/rs/core/Context");
    private final Map<MethodDef, MatchType> methodMatches = new HashMap<MethodDef, MatchType>();

    public JaxRsResourceWeaver() {
        super("JAX-RS", "org.nudge.probe.weave.jaxrs.JaxRsResourceHandler");
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        for (MethodDef md : def.getMethods()) {
            if (!this.matches(md, cl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        return MatchType.NO_MATCH != this.methodMatch(method, cl);
    }

    @Override
    public int addClassFieldsSize() {
        return 1;
    }

    @Override
    public void addClassField(ClassDef type, int i, ClassVisitor cv) {
        FieldVisitor fv = cv.visitField(0, NUDGE_URIINFO, URIINFO.getDescriptor(), URIINFO.getDescriptor(), null);
        AnnotationVisitor av = fv.visitAnnotation(CONTEXT_ANNOTATION.getDescriptor(), true);
        av.visitEnd();
        fv.visitEnd();
    }

    @Override
    public int contextFieldsSize() {
        return 4;
    }

    @Override
    public void contextFieldLoadValue(ClassDef type, MethodDef method, int i, GeneratorAdapter mv, ClassLoader classLoader) {
        String resourcePath = (String)type.getAnnotationValues(ANNOTATION_PATH).get("value");
        String methodPath = (String)method.getAnnotationValues(ANNOTATION_PATH).get("value");
        switch (i) {
            case 0: {
                JaxRsResourceWeaver.contextFieldLoadConstant(mv, resourcePath);
                break;
            }
            case 1: {
                JaxRsResourceWeaver.contextFieldLoadConstant(mv, methodPath);
                break;
            }
            case 2: {
                mv.visitVarInsn(25, 0);
                mv.getField(Type.getObjectType(type.getName()), NUDGE_URIINFO, URIINFO);
                break;
            }
            case 3: {
                MatchType methodMatch = this.methodMatch(method, classLoader);
                Type matchType = Type.getType(((Object)((Object)methodMatch)).getClass());
                mv.getStatic(matchType, methodMatch.name(), matchType);
                break;
            }
            default: {
                throw new IllegalStateException("unknown context field index");
            }
        }
    }

    private static void contextFieldLoadConstant(GeneratorAdapter mv, String value) {
        if (null == value) {
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    MatchType methodMatch(MethodDef method, ClassLoader cl) {
        MatchType match = this.methodMatches.get(method);
        if (null != match) {
            return match;
        }
        match = this.getMethodMatch(method, cl);
        this.methodMatches.put(method, match);
        return match;
    }

    private MatchType getMethodMatch(MethodDef method, ClassLoader cl) {
        for (String annotation : method.getAnnotations()) {
            ClassDef returnType;
            ClassDef annotationAnnotation = ClassDef.fromClassLoaderResource(annotation, cl);
            if (null != annotationAnnotation && annotationAnnotation.getAnnotations().contains(ANNOTATION_HTTP_METHOD)) {
                return MatchType.RESOURCE_CONTENT;
            }
            if (!annotation.equals(ANNOTATION_PATH)) continue;
            String returnTypeString = method.getSignatureReturnType();
            if (returnTypeString.startsWith("L") && returnTypeString.endsWith(";")) {
                returnTypeString = returnTypeString.substring(1, returnTypeString.length() - 1);
            }
            if (null == (returnType = ClassDef.fromClassLoaderResource(returnTypeString, cl)) || !this.matches(returnType, cl)) continue;
            return MatchType.SUB_RESOURCE;
        }
        return MatchType.NO_MATCH;
    }
}

