/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.nudge.probe.Configuration;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.events.ExtendedCode;
import org.nudge.probe.events.InstrumentationPoint;
import org.nudge.probe.events.OutputOnlyHandler;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.jdbc.JdbcConnectionNudge;
import org.nudge.probe.weave.jdbc.JdbcMetadata;

public class JdbcConnectHandler
extends OutputOnlyHandler {
    private static final Logger log = Logger.getLogger(Configuration.DEFAULT_LOGGER_NAME);

    @Override
    public void onEntering(EventContext context) {
        super.onEntering(context);
        if (context.getInstrumentationPoint().isDefineOutput() && context.getConfig().isLogStackTraceOnConnection()) {
            StringBuilder b = new StringBuilder("Entering connection here: [");
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                b.append(e.toString());
                b.append(" __ ");
            }
            b.append("]");
            log.info(b.toString(), new Object[0]);
        }
    }

    @Override
    protected void exitAsOutput(EventContext context) {
        InstrumentationPoint ip = context.getInstrumentationPoint();
        String jdbcUrl = null;
        String productName = null;
        String productVersion = null;
        Connection connection = context.getReturnValue(Connection.class);
        if (null != connection) {
            DatabaseMetaData metaData = JdbcMetadata.safeGetMetadata(connection);
            try {
                if (null != metaData) {
                    jdbcUrl = metaData.getURL();
                    productName = metaData.getDatabaseProductName();
                    productVersion = metaData.getDatabaseProductVersion();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (connection instanceof JdbcConnectionNudge && null != jdbcUrl) {
                ((JdbcConnectionNudge)((Object)connection)).nudgeSetDbUrl(jdbcUrl);
            }
        }
        context.getProtocol().createOrUpdateLayerItem(ip.getStartTime(), "SQL", "Connect", ExtendedCode.extCode("jdbc.connect", "true"), ExtendedCode.extCode("jdbc.url", jdbcUrl), ExtendedCode.extCode("jdbc.product.name", productName), ExtendedCode.extCode("jdbc.product.version", productVersion)).addCall(context);
    }
}

