/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nudge.probe.Configuration;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class JdbcConnectWeaver
extends AbstractAsmWeaver {
    private final Configuration config;

    public JdbcConnectWeaver(Configuration config) {
        super("SQL", "org.nudge.probe.weave.jdbc.JdbcConnectHandler");
        this.config = config;
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        Set<String> interfaces = def.getAllInterfaces();
        return interfaces.contains("java/sql/Driver") || interfaces.contains("javax/sql/DataSource") || interfaces.contains("jakarta/sql/DataSource") || def.getName().equals("java/sql/DriverManager");
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        if (!method.isPublic() || !method.getSignatureReturnType().equals("Ljava/sql/Connection;")) {
            return false;
        }
        String name = method.getName();
        boolean matches = false;
        List<String> parameters = method.getSignatureParameters();
        if (name.equals("connect")) {
            matches = parameters.equals(Arrays.asList("Ljava/lang/String;", "Ljava/util/Properties;"));
        } else if (name.equals("getConnection")) {
            matches = parameters.isEmpty();
            boolean bl = matches = matches || parameters.equals(Arrays.asList("Ljava/lang/String;", "Ljava/lang/String;"));
            if (method.isStatic()) {
                matches = matches || parameters.equals(Collections.singletonList("Ljava/lang/String;"));
                matches = matches || parameters.equals(Arrays.asList("Ljava/lang/String;", "Ljava/util/Properties;"));
                matches = matches || parameters.equals(Arrays.asList("Ljava/lang/String;", "java/lang/String;", "java/lang/String;"));
            }
        }
        return matches;
    }
}

