/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.Configuration;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.jdbc.JdbcConnectionNudge;

public class JdbcConnectionWeaver
extends AbstractWeaver {
    private final Configuration config;

    public JdbcConnectionWeaver(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        return def.getAllInterfaces().contains("java/sql/Connection") || def.getName().equals("weblogic/jdbc/wrapper/Connection");
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        JdbcConnectionWeaver.addField("protected java.lang.String nudgeDbUrl;", clazz);
        JdbcConnectionWeaver.addMethod("public void nudgeSetDbUrl(String url) { this.nudgeDbUrl = url; } ", clazz);
        JdbcConnectionWeaver.addMethod("public java.lang.String nudgeGetDbUrl() { return this.nudgeDbUrl; } ", clazz);
        JdbcConnectionWeaver.addInterface(JdbcConnectionNudge.class.getName(), clazz);
        return true;
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        if (name.equals("prepareStatement") && method.getSignature().startsWith("(Ljava/lang/String;")) {
            this.buildInjectSQL(method);
            return true;
        }
        if (name.equals("prepareCall") && method.getSignature().startsWith("(Ljava/lang/String;")) {
            this.buildInjectSQL(method);
            return true;
        }
        if (name.equals("close")) {
            this.buildClose(method);
            return true;
        }
        if (name.equals("commit")) {
            this.buildCommit(method);
            return true;
        }
        if (name.equals("rollback")) {
            this.buildRollback(method);
            return true;
        }
        return false;
    }

    private void buildInjectSQL(CtMethod method) throws CannotCompileException {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        sb.append("  if($_ instanceof org.nudge.probe.weave.jdbc.JdbcStatementNudge) { ");
        sb.append("    org.nudge.probe.weave.jdbc.JdbcStatementNudge nudgeStatement = (org.nudge.probe.weave.jdbc.JdbcStatementNudge)$_ ;");
        sb.append("    nudgeStatement.nudgeSetSql($1, this.nudgeDbUrl); ");
        sb.append("  } ");
        sb.append("} ");
        method.insertAfter(sb.toString(), true);
    }

    private void buildClose(CtMethod method) throws NotFoundException, CannotCompileException {
        method.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcCnxClose(); }");
        this.addCatch(method);
        method.insertAfter("{ org.nudge.probe.LoggerFactory.getLogger().exitingJdbcCnxClose(); }", true);
    }

    private void buildRollback(CtMethod method) throws NotFoundException, CannotCompileException {
        method.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcCnxRollback(); }");
        this.addCatch(method);
        method.insertAfter("{ org.nudge.probe.LoggerFactory.getLogger().exitingJdbcCnxRollback(); } ", true);
    }

    private void buildCommit(CtMethod method) throws NotFoundException, CannotCompileException {
        method.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcCnxCommit(); }");
        this.addCatch(method);
        method.insertAfter("{ org.nudge.probe.LoggerFactory.getLogger().exitingJdbcCnxCommit(); }", true);
    }
}

