/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.Configuration;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.jdbc.JdbcStatementNudge;

public class JdbcPreparedStatementWeaver
extends AbstractWeaver {
    protected static final Logger log = Logger.getLogger("org.nudge");
    private final Configuration config;

    public JdbcPreparedStatementWeaver(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        return def.getAllInterfaces().contains("java/sql/PreparedStatement");
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        JdbcPreparedStatementWeaver.addField("protected java.lang.String nudgeSql;", clazz);
        JdbcPreparedStatementWeaver.addField("protected java.lang.String nudgeDbUrl;", clazz);
        JdbcPreparedStatementWeaver.addMethod("public void nudgeSetSql(String sql, String dbUrl) { this.nudgeSql = sql; this.nudgeDbUrl = dbUrl; }", clazz);
        JdbcPreparedStatementWeaver.addInterface(JdbcStatementNudge.class.getName(), clazz);
        JdbcPreparedStatementWeaver.addSuperDelegateMethod("public boolean execute() throws java.sql.SQLException { return super.execute(); }", clazz);
        JdbcPreparedStatementWeaver.addSuperDelegateMethod("public int executeUpdate() throws java.sql.SQLException { return super.executeUpdate(); }", clazz);
        JdbcPreparedStatementWeaver.addSuperDelegateMethod("public java.sql.ResultSet executeQuery() throws java.sql.SQLException { return super.executeQuery(); }", clazz);
        JdbcPreparedStatementWeaver.addSuperDelegateMethod("public void addBatch() throws java.sql.SQLException { super.addBatch(); }", clazz);
        return true;
    }

    @Override
    public boolean instrument(CtMethod m) throws CannotCompileException, NotFoundException {
        String name = m.getName();
        if ((name.equals("execute") || name.equals("executeQuery") || name.equals("executeUpdate")) && m.getSignature().startsWith("()")) {
            this.buildExecute(m);
            return true;
        }
        if (this.config.instrumentPSSetters() && name.startsWith("set") && m.getParameterTypes().length >= 2 && m.getSignature().startsWith("(I")) {
            try {
                JdbcPreparedStatementWeaver.buildSet(m);
                return true;
            }
            catch (Exception e) {
                log.info(e, m.getLongName() + " : " + e.getMessage());
            }
        }
        return false;
    }

    private static void buildSet(CtMethod m) throws CannotCompileException {
        m.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcStmtSet($1,$2); }");
    }

    private void buildExecute(CtMethod m) throws CannotCompileException, NotFoundException {
        m.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcStmtExecute(); }");
        this.addCatch(m);
        StringBuffer buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  long t0 = System.nanoTime(); ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  long sqlId = -1;");
        buf.append("  int rowCount = 0;");
        if ("executeUpdate".equals(m.getName())) {
            buf.append("  rowCount = $_;");
        }
        buf.append("  String dbUrl = this.nudgeDbUrl; ");
        buf.append("  if( null == dbUrl ){ dbUrl = logger.getDbUrl(this.getConnection()); }");
        buf.append("  sqlId = logger.exitingJdbcStmtExecute(this.nudgeSql,dbUrl,false,rowCount); ");
        if ("executeQuery".equals(m.getName())) {
            buf.append("  if($_ instanceof org.nudge.probe.weave.jdbc.JdbcResultSetNudge) { ");
            buf.append("    ((org.nudge.probe.weave.jdbc.JdbcResultSetNudge)$_).nudgeSetSqlId(sqlId); ");
            buf.append("  } ");
        }
        buf.append("  logger.logNudgeCpuOverhead(System.nanoTime()-t0); ");
        buf.append("} ");
        m.insertAfter(buf.toString(), true);
    }
}

