/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import java.util.Arrays;
import java.util.List;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtClass;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.Configuration;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.jdbc.JdbcResultSetNudge;

public class JdbcResultSetWeaver
extends AbstractWeaver {
    private static final List<String> shouldMatch = Arrays.asList("org/postgresql/jdbc2/AbstractJdbc2ResultSet", "com/mysql/jdbc/JDBC4ResultSet", "com/mysql/jdbc/JDBC4UpdatableResultSet", "com/mysql/jdbc/ResultSetImpl", "com/mysql/jdbc/UpdatableResultSet");
    private final Configuration config;

    public JdbcResultSetWeaver(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        if (shouldMatch.contains(def.getName())) {
            return true;
        }
        return def.getAllInterfaces().contains("java/sql/ResultSet");
    }

    @Override
    public boolean beforeInstrument(CtClass clazz) throws CannotCompileException, NotFoundException {
        JdbcResultSetWeaver.addField("private long nudgeSqlId;", clazz);
        JdbcResultSetWeaver.addField("private int nudgeFetchCount;", clazz);
        JdbcResultSetWeaver.addField("private long nudgeFetchTotal;", clazz);
        JdbcResultSetWeaver.addField("private long nudgeFetchMax;", clazz);
        JdbcResultSetWeaver.addField("private long nudgeFetchMin;", clazz);
        JdbcResultSetWeaver.addField("private long nudgeFetchStartTime;", clazz);
        StringBuffer buf = new StringBuffer(500);
        buf.append("private void nudgeLogFetch() { ");
        buf.append("\tlong duration = System.nanoTime() - nudgeFetchStartTime; ");
        buf.append("\tnudgeFetchTotal += duration; ");
        buf.append("    nudgeFetchCount++; ");
        buf.append("    if (nudgeFetchMax < duration) { ");
        buf.append("\t\tnudgeFetchMax = duration; ");
        buf.append("    } ");
        buf.append("    if (nudgeFetchMin > duration) { ");
        buf.append("\t\tnudgeFetchMin = duration; ");
        buf.append("    } ");
        buf.append("} ");
        JdbcResultSetWeaver.addMethod(buf.toString(), clazz);
        buf = new StringBuffer(500);
        buf.append("public void nudgeSetSqlId(long id) { ");
        buf.append("  this.nudgeSqlId = id; ");
        buf.append("} ");
        JdbcResultSetWeaver.addMethod(buf.toString(), clazz);
        JdbcResultSetWeaver.addInterface(JdbcResultSetNudge.class.getName(), clazz);
        return true;
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        if (name.equals("next")) {
            this.next(method);
            return true;
        }
        if (name.equals("close")) {
            this.close(method);
            return true;
        }
        return false;
    }

    private void next(CtMethod m) throws CannotCompileException, NotFoundException {
        m.insertBefore("{ this.nudgeFetchStartTime = System.nanoTime(); }");
        this.addCatch(m);
        m.insertAfter("{ this.nudgeLogFetch(); }", true);
    }

    private void close(CtMethod m) throws CannotCompileException, NotFoundException {
        StringBuffer buf = new StringBuffer(200);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  logger.enteringJdbcFetch(); ");
        buf.append("} ");
        m.insertBefore(buf.toString());
        this.addCatch(m);
        buf = new StringBuffer(200);
        buf.append("{ ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  double avg = (double)nudgeFetchTotal / (double)(nudgeFetchCount * 1000 * 1000);");
        buf.append("  long max = this.nudgeFetchMax / (1000*1000);");
        buf.append("  long min = this.nudgeFetchMin / (1000*1000);");
        buf.append("  logger.exitingJdbcFetch( nudgeSqlId, nudgeFetchCount, avg, max, min ); ");
        buf.append("  this.nudgeSqlId = -1;");
        buf.append("  this.nudgeFetchCount = 0;");
        buf.append("  this.nudgeFetchTotal = 0;");
        buf.append("  this.nudgeFetchMax = 0;");
        buf.append("  this.nudgeFetchMin = 0;");
        buf.append("} ");
        m.insertAfter(buf.toString(), true);
    }
}

