/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdbc;

import java.lang.reflect.Modifier;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.Configuration;
import org.nudge.probe.weave.AbstractWeaver;
import org.nudge.probe.weave.ClassDef;

public class JdbcStatementWeaver
extends AbstractWeaver {
    private final Configuration config;

    public JdbcStatementWeaver(Configuration config) {
        this.config = config;
    }

    @Override
    public boolean matches(ClassDef def, ClassLoader cl) {
        boolean isStatement = false;
        boolean isPreparedStatement = false;
        for (String name : def.getAllInterfaces()) {
            if ("java/sql/Statement".equals(name)) {
                isStatement = true;
                continue;
            }
            if (!"java/sql/PreparedStatement".equals(name)) continue;
            isPreparedStatement = true;
        }
        return isStatement && !isPreparedStatement;
    }

    @Override
    public boolean instrument(CtMethod m) throws CannotCompileException, NotFoundException {
        if (!Modifier.isPublic(m.getModifiers())) {
            return false;
        }
        String name = m.getName();
        if (name.equals("execute") || name.equals("executeQuery") || name.equals("executeUpdate")) {
            if (m.getSignature().startsWith("(Ljava/lang/String;")) {
                this.execute(m);
                return true;
            }
        } else {
            if (name.equals("close")) {
                this.close(m);
                return true;
            }
            if (name.equals("executeBatch")) {
                this.wrapMethod(m, "org.nudge.probe.weave.jdbc.JdbcExecuteBatchHandler", "SQL");
                return true;
            }
        }
        return false;
    }

    private void execute(CtMethod m) throws CannotCompileException, NotFoundException {
        m.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcStmtExecute(); }");
        this.addCatch(m);
        StringBuffer buf = new StringBuffer(1000);
        buf.append("{ ");
        buf.append("  long t0 = System.nanoTime(); ");
        buf.append("  org.nudge.probe.NudgeLogger logger = org.nudge.probe.LoggerFactory.getLogger(); ");
        buf.append("  long sqlId = -1;");
        buf.append("  String url = logger.getDbUrl(this.getConnection());");
        buf.append("  int rowCount = 0;");
        if ("executeUpdate".equals(m.getName())) {
            buf.append("  rowCount = $_;");
        }
        buf.append("  sqlId = logger.exitingJdbcStmtExecute($1,url,true,rowCount); ");
        if ("executeQuery".equals(m.getName())) {
            buf.append("  if($_ instanceof org.nudge.probe.weave.jdbc.JdbcResultSetNudge) { ");
            buf.append("    ((org.nudge.probe.weave.jdbc.JdbcResultSetNudge)$_).nudgeSetSqlId(sqlId); ");
            buf.append("  } ");
        }
        buf.append("  logger.logNudgeCpuOverhead(System.nanoTime()-t0); ");
        buf.append("} ");
        m.insertAfter(buf.toString(), true);
    }

    private void close(CtMethod method) throws CannotCompileException, NotFoundException {
        method.insertBefore("{ org.nudge.probe.LoggerFactory.getLogger().enteringJdbcStmtClose(); }");
        this.addCatch(method);
        method.insertAfter("{ org.nudge.probe.LoggerFactory.getLogger().exitingJdbcStmtClose(); }", true);
    }
}

