/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import java.net.HttpURLConnection;
import org.nudge.probe.events.EventContext;
import org.nudge.probe.log.Logger;
import org.nudge.probe.weave.http.AbstractHttpClientHandler;

public class HttpURLConnectionHandler
extends AbstractHttpClientHandler {
    private static final Logger log = Logger.getLogger(HttpURLConnectionHandler.class.getName());

    @Override
    protected AbstractHttpClientHandler.HttpRequestContextAdapter getHttpRequest(EventContext context) {
        final HttpURLConnection connection = context.getMethodTarget(HttpURLConnection.class);
        final boolean skipMethod = !"connect".equals(context.getMethodName());
        return new AbstractHttpClientHandler.HttpRequestContextAdapter(){

            @Override
            public boolean skip() {
                return null == connection || skipMethod;
            }

            @Override
            public String getMethod() {
                return connection.getRequestMethod();
            }

            @Override
            public String getUri() {
                return connection.getURL().toString();
            }

            @Override
            public int getResponseStatusCode() {
                return -1;
            }

            @Override
            public String getHeader(String header) {
                return connection.getRequestProperty(header);
            }

            @Override
            public void setHeader(String header, String value) {
                try {
                    connection.setRequestProperty(header, value);
                }
                catch (IllegalStateException e) {
                    log.fine(e, "unable to set http header", new Object[0]);
                }
            }
        };
    }
}

