/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.nudge.probe.weave.AbstractAsmWeaver;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.MethodDef;

public class HttpURLConnectionWeaver
extends AbstractAsmWeaver {
    private static final String URL_CONNECTION = "java/net/HttpURLConnection";
    private static final Set<String> METHODS = new HashSet<String>(Arrays.asList("connect", "getInputStream", "getOutputStream"));

    public HttpURLConnectionWeaver() {
        super("HTTP", "org.nudge.probe.weave.jdk.HttpURLConnectionHandler");
    }

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        return clazz.getAllSuperNames().contains(URL_CONNECTION);
    }

    @Override
    public boolean matches(MethodDef method, ClassLoader cl) {
        String methodName = method.getName();
        return METHODS.contains(methodName);
    }
}

