/*
 * Decompiled with CFR 0.152.
 */
package org.nudge.probe.weave.jdk;

import java.util.Arrays;
import java.util.List;
import org.nudge.javassist.CannotCompileException;
import org.nudge.javassist.CtMethod;
import org.nudge.javassist.Modifier;
import org.nudge.javassist.NotFoundException;
import org.nudge.probe.weave.ClassDef;
import org.nudge.probe.weave.jdk.ThreadWeaver;

public class RunnableWeaver
extends ThreadWeaver {
    private static final String RUNNABLE = "java/lang/Runnable";
    private static final List<String> excludedPackages = Arrays.asList("com/mchange/v2/resourcepool", "org/jboss/msc");

    @Override
    public boolean matches(ClassDef clazz, ClassLoader cl) {
        for (String packageName : excludedPackages) {
            if (!clazz.getName().startsWith(packageName)) continue;
            return false;
        }
        if ("java/lang/Thread".equals(clazz.getName())) {
            return false;
        }
        for (String superName : clazz.getAllSuperNames()) {
            if (!superName.equals("java/lang/Thread")) continue;
            return false;
        }
        for (String name : clazz.getAllInterfaces()) {
            if (!RUNNABLE.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean instrument(CtMethod method) throws CannotCompileException, NotFoundException {
        String name = method.getName();
        int modifiers = method.getModifiers();
        if (name.equals("run") && Modifier.isPublic(modifiers)) {
            this.instrumentRun(method);
            return true;
        }
        return false;
    }
}

